/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;

public class SDMXMeasureStatus {
    public static final String STATUS_OFFICIAL = "";
    public static final String STATUS_UNAVAILABLE = "M";
    public static final String STATUS_NEGLIBILE = "N";
    public static final String STATUS_ZERO = "O";
    public static final String STATUS_ESTIMATE = "E";
    public static final String STATUS_MIRRORED = "T";
    public static final String STATUS_IMPUTED = "I";
    public static final String STATUS_DISPLAY_UNAVAILABLE = "...";
    public static final String STATUS_DISPLAY_BLANK = "[blank]";
    public static final String STATUS_OFFICIAL_FIGIS = " ";
    public static final String STATUS_UNAVAILABLE_FIGIS = ".";
    public static final String STATUS_NEGLIBILE_FIGIS = "0";
    public static final String STATUS_ZERO_FIGIS = "-";
    public static final String STATUS_ESTIMATE_FIGIS = "F";
    public static final MeasureStatus OFFICIAL = new MeasureStatus("", " ");
    public static final MeasureStatus UNAVAILABLE = new MeasureStatus("M", ".");
    public static final MeasureStatus NEGLIBILE = new MeasureStatus("N", "0");
    public static final MeasureStatus ZERO = new MeasureStatus("O", "-");
    public static final MeasureStatus ESTIMATE = new MeasureStatus("E", "F");
    public static final MeasureStatus MIRRORED = new MeasureStatus("T");
    public static final MeasureStatus IMPUTED = new MeasureStatus("I");
    private static Map<String, MeasureStatus> ALL_MEASURES = new HashMap<String, MeasureStatus>();
    private static List<String> VALID_STATUS = new ArrayList<String>();

    public static Map<String, MeasureStatus> getAllSymbols() {
        if (ALL_MEASURES.isEmpty()) {
            ALL_MEASURES.put(STATUS_OFFICIAL, OFFICIAL);
            ALL_MEASURES.put(STATUS_UNAVAILABLE, UNAVAILABLE);
            ALL_MEASURES.put(STATUS_NEGLIBILE, NEGLIBILE);
            ALL_MEASURES.put(STATUS_ZERO, ZERO);
            ALL_MEASURES.put(STATUS_ESTIMATE, ESTIMATE);
            ALL_MEASURES.put(STATUS_MIRRORED, MIRRORED);
            ALL_MEASURES.put(STATUS_IMPUTED, IMPUTED);
            ALL_MEASURES.put(STATUS_OFFICIAL_FIGIS, OFFICIAL);
            ALL_MEASURES.put(STATUS_UNAVAILABLE_FIGIS, UNAVAILABLE);
            ALL_MEASURES.put(STATUS_NEGLIBILE_FIGIS, NEGLIBILE);
            ALL_MEASURES.put(STATUS_ZERO_FIGIS, ZERO);
            ALL_MEASURES.put(STATUS_ESTIMATE_FIGIS, ESTIMATE);
        }
        return ALL_MEASURES;
    }

    public static MeasureStatus getMeasure(String status) throws TimeseriesServiceException {
        MeasureStatus measure = SDMXMeasureStatus.getAllSymbols().get(status);
        if (measure == null) {
            throw new TimeseriesServiceException("MeasureStatus is not valid=" + status);
        }
        return measure;
    }

    public static List<String> getValidStatus() {
        if (VALID_STATUS.isEmpty()) {
            VALID_STATUS.add(STATUS_OFFICIAL);
            VALID_STATUS.add(STATUS_UNAVAILABLE);
            VALID_STATUS.add(STATUS_NEGLIBILE);
            VALID_STATUS.add(STATUS_ZERO);
            VALID_STATUS.add(STATUS_ESTIMATE);
            VALID_STATUS.add(STATUS_MIRRORED);
            VALID_STATUS.add(STATUS_IMPUTED);
        }
        return VALID_STATUS;
    }

    public static boolean isValidStatus(String status) {
        if (status == null) {
            return true;
        }
        return SDMXMeasureStatus.getValidStatus().contains(status);
    }
}

