/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreUtils;
import org.osgi.framework.Bundle;

public class VersionId
implements Comparable<VersionId>,
Cloneable {
    private Integer major;
    private Integer minor;
    private Integer fixes;
    private String author;
    private Date datedate;

    public VersionId() {
    }

    public VersionId(String textual) {
        this.setNumber(textual);
    }

    public Integer getMajor() {
        return this.major;
    }

    public void setMajor(Integer major) {
        this.major = major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public void setMinor(Integer minor) {
        this.minor = minor;
    }

    public Integer getFixes() {
        return this.fixes;
    }

    public void setFixes(Integer fixes) {
        this.fixes = fixes;
    }

    public String getNumber() {
        return this.major + "." + this.minor + "." + this.fixes;
    }

    public void setNumber(String txtNumber) {
        if (txtNumber == null) {
            throw new RuntimeException("Invalid null string in version number");
        }
        if (txtNumber.equals("")) {
            throw new RuntimeException("Invalid empty string in version number");
        }
        String[] segments = txtNumber.split("\\.");
        int[] res = new int[segments.length];
        int i = 0;
        while (i < segments.length) {
            String current = i == 0 ? "major" : (i == 1 ? "minor" : "fixes");
            try {
                res[i] = Integer.parseInt(segments[i]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Invalid " + current + " version number detected.");
            }
            ++i;
        }
        this.major = 0;
        this.minor = 0;
        this.fixes = 0;
        if (res.length > 0) {
            this.major = res[0];
        }
        if (res.length > 1) {
            this.minor = res[1];
        }
        if (res.length > 2) {
            this.fixes = res[2];
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDateDate() {
        return this.datedate;
    }

    public String getDate() {
        try {
            return new SimpleDateFormat(CoreUtils.VERSION_ID_DATE_FORMAT).format(this.datedate);
        }
        catch (Exception exception) {
            return "2014-01-01";
        }
    }

    public void setDateDate(Date date) {
        this.datedate = date;
    }

    public void setDate(String date) {
        if (date != null && date.length() == CoreUtils.VERSION_ID_DATE_FORMAT.length()) {
            try {
                this.datedate = new SimpleDateFormat(CoreUtils.VERSION_ID_DATE_FORMAT).parse(date);
            }
            catch (Exception exp) {
                ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
                log.log((IStatus)new Status(1, this.getClass().getName(), "date conversion from " + date, (Throwable)exp));
            }
        }
    }

    public static boolean isValid(String txtNumber) {
        if (txtNumber == null) {
            return false;
        }
        if (txtNumber.equals("")) {
            return false;
        }
        String[] segments = txtNumber.split("\\.");
        int[] res = new int[segments.length];
        int i = 0;
        while (i < segments.length) {
            try {
                res[i] = Integer.parseInt(segments[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0 instanceof VersionId) {
            if (this.major == null || this.minor == null || this.fixes == null) {
                return false;
            }
            if (this.major.compareTo(((VersionId)arg0).major) == 0 && this.minor.compareTo(((VersionId)arg0).minor) == 0 && this.fixes.compareTo(((VersionId)arg0).fixes) == 0) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.major == null) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        res.append(this.major);
        if (this.minor == null) {
            return res.toString();
        }
        res.append(".");
        res.append(this.minor);
        if (this.fixes == null) {
            return res.toString();
        }
        res.append(".");
        res.append(this.fixes);
        return res.toString();
    }

    @Override
    public int compareTo(VersionId arg0) {
        if (this.major.equals(arg0.major)) {
            if (this.minor.equals(arg0.minor)) {
                return this.fixes.compareTo(arg0.fixes);
            }
            return this.minor.compareTo(arg0.minor);
        }
        return this.major.compareTo(arg0.major);
    }

    public VersionId clone() {
        VersionId res = new VersionId();
        res.fixes = this.fixes;
        res.major = this.major;
        res.minor = this.minor;
        res.author = this.author != null ? new String(this.author) : null;
        res.datedate = this.datedate != null ? (Date)this.datedate.clone() : null;
        return res;
    }
}

