/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.aggregation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;

public class DimensionAggregation
extends Observable {
    public static final int TYPE_DETAILED = 0;
    public static final int TYPE_GROUPED_BASIC = 1;
    public static final int TYPE_GROUPED_HANDPICKED = 2;
    public static final int TYPE_AGGREGATED = 3;
    private int type;
    private Dimension dimension;
    private Concept basicAggregator;
    private Concept[] allparents;
    private Hashtable<Concept, Set<ReferenceObject>> includes;
    private Hashtable<Concept, Set<ReferenceObject>> excludes;

    public DimensionAggregation(Dimension dimension) throws ReferenceServiceException {
        this.dimension = dimension;
        this.allparents = CoreUtils.getDimensionParents(dimension, true);
        this.excludeAll();
    }

    public int getType() {
        return this.type;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Set<ReferenceObject> getAllIncludes() {
        Collection<Set<ReferenceObject>> values = this.includes.values();
        HashSet<ReferenceObject> result = new HashSet<ReferenceObject>(values.size() * 10);
        switch (this.type) {
            case 1: {
                Iterator<Set<ReferenceObject>> iterator = values.iterator();
                while (iterator.hasNext()) {
                    result.addAll(iterator.next());
                }
                break;
            }
            case 2: {
                Iterator<Set<ReferenceObject>> iterator = values.iterator();
                while (iterator.hasNext()) {
                    result.addAll(iterator.next());
                }
                break;
            }
            case 3: {
                result.add(ReferenceObject.ALL);
                break;
            }
        }
        return result;
    }

    public void setBasicConceptAggregation(Concept c) {
        this.type = 1;
        this.excludeAll();
        this.basicAggregator = c;
        this.addIncludes(c);
    }

    public void setAggregatedDimension() {
        this.type = 3;
        this.basicAggregator = null;
    }

    public void setDetailedDimension() {
        this.type = 0;
        this.basicAggregator = null;
    }

    public void setHandPickedAggregation() {
        this.type = 2;
        this.excludeAll();
        this.basicAggregator = null;
    }

    public boolean nothingToAggregate() {
        return this.type == 0 || this.type != 3 && this.includes.size() == 0;
    }

    public void addIncluded(ReferenceObject ro, boolean notify) {
        if (!this.includes.containsKey(ro.getConcept())) {
            this.includes.put(ro.getConcept(), new HashSet());
        }
        this.includes.get(ro.getConcept()).add(ro);
        if (this.excludes.containsKey(ro.getConcept())) {
            if (this.excludes.get(ro.getConcept()).size() == 1) {
                this.excludes.remove(ro.getConcept());
            } else {
                this.excludes.get(ro.getConcept()).remove(ro);
            }
        }
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void remIncluded(ReferenceObject ro, boolean notify) {
        if (!this.excludes.containsKey(ro.getConcept())) {
            this.excludes.put(ro.getConcept(), new HashSet());
        }
        this.excludes.get(ro.getConcept()).add(ro);
        if (this.includes.containsKey(ro.getConcept())) {
            if (this.includes.get(ro.getConcept()).size() == 1) {
                this.includes.remove(ro.getConcept());
            } else {
                this.includes.get(ro.getConcept()).remove(ro);
            }
        }
        this.setChanged();
        if (notify) {
            this.notifyObservers();
        }
    }

    public void addIncludes(Concept c) {
        block7: {
            if (!this.includes.containsKey(c)) {
                try {
                    if (c.getAcronym().equals("CUSTOM_GROUP")) {
                        this.includes.put(c, new HashSet<ReferenceObject>(CoreUtils.getReferenceObjectsCustomGroups(this.dimension.getConcept())));
                        break block7;
                    }
                    if (c.equals(this.dimension.getConcept())) {
                        this.includes.put(c, this.excludes.get(c));
                        break block7;
                    }
                    Relationship relationship = ReferenceServiceFactory.getService().getRelationship(c, this.dimension.getConcept());
                    this.includes.put(c, new HashSet(relationship.getParents()));
                }
                catch (ReferenceServiceException e) {
                    e.printStackTrace();
                }
            } else {
                this.includes.get(c).addAll((Collection<ReferenceObject>)this.excludes.get(c));
            }
        }
        if (this.excludes.containsKey(c)) {
            this.excludes.remove(c);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void remIncludes(Concept c) {
        block6: {
            if (!this.excludes.containsKey(c)) {
                try {
                    if (c.getAcronym().equals("CUSTOM_GROUP")) {
                        this.excludes.put(c, new HashSet<ReferenceObject>(CoreUtils.getReferenceObjectsCustomGroups(this.dimension.getConcept())));
                        break block6;
                    }
                    this.excludes.put(c, new HashSet(c.getObjects()));
                }
                catch (ReferenceServiceException e) {
                    e.printStackTrace();
                }
            } else {
                this.excludes.get(c).addAll((Collection<ReferenceObject>)this.includes.get(c));
            }
        }
        if (this.includes.containsKey(c)) {
            this.includes.remove(c);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isIncluded(ReferenceObject o) {
        if (this.includes.containsKey(o.getConcept())) {
            return this.includes.get(o.getConcept()).contains(o);
        }
        return false;
    }

    public Set<ReferenceObject> getIncludes(Concept parent) {
        return this.includes.get(parent);
    }

    public Enumeration<Concept> getIncludeParents() {
        return this.includes.keys();
    }

    public int getIncludeParentsSize() {
        return this.includes.size();
    }

    public Set<ReferenceObject> getExcludes(Concept parent) {
        return this.excludes.get(parent);
    }

    public boolean isNothingIncluded(Concept c) {
        if (this.includes.containsKey(c)) {
            return this.includes.get(c).size() == 0;
        }
        return true;
    }

    public boolean isNothingExcluded(Concept c) {
        if (this.excludes.containsKey(c)) {
            return this.excludes.get(c).size() == 0;
        }
        return true;
    }

    public boolean isNothingIncluded() {
        return this.includes.size() == 0;
    }

    public boolean isNothingExcluded() {
        return this.excludes.size() == 0;
    }

    public Enumeration<Concept> getExcludeParents() {
        return this.excludes.keys();
    }

    public int getExcludeParentsSize() {
        return this.excludes.size();
    }

    public Concept[] getAllParents() {
        return this.allparents;
    }

    public int getAllParentsSize() {
        return this.allparents.length;
    }

    public List<Concept> getInvolvedParents() {
        LinkedList<Concept> res = new LinkedList<Concept>();
        Enumeration<Concept> ei = this.includes.keys();
        while (ei.hasMoreElements()) {
            Concept concept = ei.nextElement();
            if (res.contains(concept)) continue;
            res.add(concept);
        }
        Enumeration<Concept> ee = this.excludes.keys();
        while (ee.hasMoreElements()) {
            Concept concept = ee.nextElement();
            if (res.contains(concept)) continue;
            res.add(concept);
        }
        return res;
    }

    public Concept getBasicAggregator() {
        return this.basicAggregator;
    }

    public void excludeAll() {
        this.basicAggregator = null;
        this.includes = new Hashtable();
        this.excludes = new Hashtable();
        this.buildCompleteTree(this.excludes);
        this.setChanged();
        this.notifyObservers();
    }

    public void includeAll() {
        this.basicAggregator = null;
        this.includes = new Hashtable();
        this.excludes = new Hashtable();
        this.buildCompleteTree(this.includes);
        this.setChanged();
        this.notifyObservers();
    }

    private void buildCompleteTree(Hashtable<Concept, Set<ReferenceObject>> structure) {
        int i = 0;
        while (i < this.allparents.length) {
            try {
                if (this.allparents[i].getAcronym().equals("CUSTOM_GROUP")) {
                    structure.put(this.allparents[i], new HashSet<ReferenceObject>(CoreUtils.getReferenceObjectsCustomGroups(this.dimension.getConcept())));
                } else {
                    structure.put(this.allparents[i], new HashSet(this.allparents[i].getObjects()));
                }
            }
            catch (ReferenceServiceException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

