/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.validators;

import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptSortorderValidator
implements IValidator<Object> {
    private Concept original;

    public ConceptSortorderValidator(Concept instance) {
        this.original = instance;
    }

    public IStatus validate(Object value) {
        if (value == null) {
            return Status.OK_STATUS;
        }
        int sortorder = 0;
        if (value instanceof Integer) {
            sortorder = (Integer)value;
        } else {
            if (!(value instanceof String)) {
                return ValidationStatus.error((String)"Expected a string input");
            }
            if (((String)value).isEmpty()) {
                return Status.OK_STATUS;
            }
            try {
                sortorder = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return ValidationStatus.error((String)"Only numeric values are allowed here");
            }
        }
        if (sortorder < 1) {
            return ValidationStatus.error((String)"Zero is not allowed");
        }
        if (sortorder > 99999) {
            return ValidationStatus.error((String)"Input is too large");
        }
        if (this.original != null && (this.original.getSortorder() == null || this.original.getSortorder() == sortorder)) {
            return Status.OK_STATUS;
        }
        List concepts = ReferenceServiceFactory.getService().getConcepts();
        for (Concept concept : concepts) {
            if (concept.getSortorder() == null || concept.getSortorder() != sortorder) continue;
            return ValidationStatus.error((String)("This sortorder is already used by " + concept.getAcronym()));
        }
        return Status.OK_STATUS;
    }
}

