/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import com.csvreader.CsvWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class WorkspaceDataExporter {
    public static void exportReferenceObjects(String filePath, Concept concept) throws Exception {
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8);
        CsvWriter writer = null;
        try {
            try {
                ArrayList<String> csvHeaders = new ArrayList<String>();
                writer = new CsvWriter((Writer)output, ',');
                for (Attribute attribute : concept.getAttributes()) {
                    if (attribute.getAcronym().equals("ID")) continue;
                    if (!attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                        csvHeaders.add(attribute.getAcronym());
                        continue;
                    }
                    for (String lang : MultilingualString.LANGUAGES) {
                        csvHeaders.add(String.valueOf(attribute.getAcronym()) + "_" + lang.toUpperCase());
                    }
                }
                writer.writeRecord(csvHeaders.toArray(new String[csvHeaders.size()]));
                for (ReferenceObject ro : concept.getObjects()) {
                    ArrayList<String> record = new ArrayList<String>();
                    for (Attribute attribute : concept.getAttributes()) {
                        if (attribute.getAcronym().equals("ID")) continue;
                        Object value = ro.getAttribute(attribute);
                        if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                            MultilingualString multi_string_value = (MultilingualString)value;
                            for (String language : MultilingualString.LANGUAGES) {
                                record.add(multi_string_value.getValue(language));
                            }
                            continue;
                        }
                        record.add(value == null ? null : String.valueOf(value));
                    }
                    writer.writeRecord(record.toArray(new String[record.size()]));
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to generate CSV file from reference objects. " + e.getMessage());
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            output.close();
        }
    }

    public static void exportRelationships(String filePath, Relationship relationship) throws Exception {
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8);
        CsvWriter writer = null;
        try {
            try {
                writer = new CsvWriter((Writer)output, ',');
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("PARENT_ID");
                headers.add("CHILD_ID");
                writer.writeRecord(headers.toArray(new String[headers.size()]));
                for (ReferenceObject parent : relationship.getParents()) {
                    String parent_value = parent.getAttribute("EBXID").toString();
                    if (parent_value == null) {
                        throw new Exception("Parent reference attribute is null: " + parent);
                    }
                    for (ReferenceObject child : relationship.getChildren(parent)) {
                        String child_value = child.getAttribute("EBXID").toString();
                        if (child_value == null) {
                            throw new Exception("Child reference attribute is null: " + parent);
                        }
                        ArrayList<String> record = new ArrayList<String>();
                        record.add(parent_value);
                        record.add(child_value);
                        writer.writeRecord(record.toArray(new String[record.size()]));
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to download relationship. " + e.getMessage());
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            output.close();
        }
    }
}

