/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.generated.workspaces.attachments.Attachments;
import org.fao.fi.fishstat.core.generated.workspaces.attachments.FishstatjAttachments;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Concept;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.FishstatjConcepts;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Relationship;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.FishstatjDatasets;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Timeseries;
import org.fao.fi.fishstat.core.generated.workspaces.workspace.Workspace;
import org.fao.fi.fishstat.core.model.attachment.AttachmentModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.relationship.RelationshipModel;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.DimensionModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceAdapters;
import org.fao.fi.fishstat.data.common.ddlutils.DdlUtilsHelper;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;

public class WorkspaceStructureImporter {
    public static final String ATTACHMENTS_FILE = "attachments.xml";

    public static FishstatjConcepts importConcepts(File candidateFile, ILog logger) throws Exception {
        FileInputStream is = new FileInputStream(candidateFile);
        BufferedReader utf8XmlReader = new BufferedReader(new InputStreamReader(CoreUtils.openFileDiscardBOM(is), StandardCharsets.UTF_8));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FishstatjConcepts.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        FishstatjConcepts fishstatjConcepts = (FishstatjConcepts)jaxbUnmarshaller.unmarshal((Reader)utf8XmlReader);
        return fishstatjConcepts;
    }

    public static void persistConceptRelationship(List<Concept> conceptData, List<Relationship> relationData, ILog logger, SubMonitor submonitor) throws Exception {
        submonitor.beginTask("Persisting concepts and relationships...", conceptData.size() + relationData.size());
        for (Concept xml_concept : conceptData) {
            ConceptModel concept_model = WorkspaceAdapters.getConcept(xml_concept);
            PersistenceServiceFactory.getReferenceService().persistConcept(concept_model);
            submonitor.worked(1);
            logger.log((IStatus)new Status(1, WorkspaceStructureImporter.class.getName(), "Concept " + concept_model.getAcronym() + " successfully created"));
        }
        for (Relationship xml_relationship : relationData) {
            RelationshipModel concept_relationship_model = WorkspaceAdapters.getRelationshipModel(xml_relationship);
            PersistenceServiceFactory.getReferenceService().persistRelationship(concept_relationship_model);
            submonitor.worked(1);
            logger.log((IStatus)new Status(1, WorkspaceStructureImporter.class.getName(), "Relationship " + xml_relationship.getAcronym() + " successfully created"));
        }
    }

    public static FishstatjDatasets importDatasets(File candidateFile, ILog logger) throws Exception {
        FileInputStream is = new FileInputStream(candidateFile);
        BufferedReader utf8XmlReader = new BufferedReader(new InputStreamReader(CoreUtils.openFileDiscardBOM(is), StandardCharsets.UTF_8));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FishstatjDatasets.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        FishstatjDatasets fishstatjDatasets = (FishstatjDatasets)jaxbUnmarshaller.unmarshal((Reader)utf8XmlReader);
        return fishstatjDatasets;
    }

    public static void persistDatasets(List<org.fao.fi.fishstat.core.generated.workspaces.datasets.Dataset> dsList, ILog logger, SubMonitor submonitor) throws Exception {
        submonitor.beginTask("Persisting concepts and relationships...", dsList.size());
        for (org.fao.fi.fishstat.core.generated.workspaces.datasets.Dataset xml_dataset : dsList) {
            String acronym = xml_dataset.getAcronym();
            Dataset ori_dataset = TimeseriesServiceFactory.getService().getDataset(acronym);
            if (ori_dataset != null) {
                throw new Exception("Dataset does not exist " + ori_dataset.getAcronym());
            }
            String dataset_acronym = xml_dataset.getAcronym();
            DatasetModel dataset_model = WorkspaceAdapters.getDataset(xml_dataset, logger);
            dataset_model.persistModel(null);
            submonitor.worked(1);
            for (Timeseries timeseries : xml_dataset.getTimeseries()) {
                TimeseriesModel timeseriesModel = WorkspaceAdapters.getTimeseries(dataset_acronym, timeseries);
                PersistenceServiceFactory.getTimeseriesService().persistNewTimeseries(dataset_acronym, timeseriesModel);
            }
            for (DimensionModel dimensionModel : dataset_model.getDimensionModels()) {
                if (!dimensionModel.getHasNote()) continue;
                String notesTable = "NOTE_" + dataset_model.getAcronym().toUpperCase(Locale.ENGLISH) + "_" + dimensionModel.getAcronym().toUpperCase(Locale.ENGLISH);
                WorkspaceStructureImporter.createDimensionNote(notesTable);
            }
            logger.log((IStatus)new Status(0, WorkspaceStructureImporter.class.getName(), "Dataset " + xml_dataset.getAcronym() + " successfully created"));
        }
    }

    private static void createDimensionNote(String noteAcronym) throws Exception {
        Table table = TimeseriesManagementServiceFactory.getService().createDimensionNoteTable(noteAcronym);
        Database model = DdlUtilsHelper.reloadDatabase();
        model.addTable(table);
        DdlUtilsHelper.alterDatabase((Database)model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<AttachmentModel> importAttachment(ILog logger, File file) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStream inputStream;
                block20: {
                    Enumeration<? extends ZipEntry> entries;
                    ZipFile zipFile;
                    block19: {
                        zipFile = new ZipFile(file);
                        entries = zipFile.entries();
                        finally {
                            if (entries.hasMoreElements()) break block19;
                            return new ArrayList<AttachmentModel>();
                        }
                    }
                    ZipEntry zipEntry = entries.nextElement();
                    try {
                        Throwable throwable2 = null;
                        Object var8_13 = null;
                        try {
                            List<AttachmentModel> list;
                            inputStream = zipFile.getInputStream(zipEntry);
                            try {
                                if (!zipEntry.getName().equals(ATTACHMENTS_FILE)) break block20;
                                JAXBContext jaxbContext2 = JAXBContext.newInstance((Class[])new Class[]{FishstatjAttachments.class, Attachments.class});
                                Unmarshaller jaxbUnmarshaller2 = jaxbContext2.createUnmarshaller();
                                FishstatjAttachments xmlAtts = (FishstatjAttachments)jaxbUnmarshaller2.unmarshal(inputStream);
                                list = WorkspaceAdapters.extractAttachments(xmlAtts.getAttachments().getAttachment());
                                if (inputStream == null) return list;
                            }
                            catch (Throwable throwable3) {
                                if (inputStream == null) throw throwable3;
                                inputStream.close();
                                throw throwable3;
                            }
                            inputStream.close();
                            return list;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                    catch (Exception e1) {
                        logger.log((IStatus)new Status(4, WorkspaceStructureImporter.class.getName(), "Error read attachments from " + file.getAbsolutePath()));
                        throw e1;
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Exception e2) {
            logger.log((IStatus)new Status(4, WorkspaceStructureImporter.class.getName(), "Error read zip file " + file.getAbsolutePath(), (Throwable)e2));
            throw e2;
        }
    }

    private static void copyAttachmentFiles(ILog logger, File file) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    try {
                        Throwable throwable2 = null;
                        Object var8_13 = null;
                        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                            int n;
                            if (zipEntry.getName().equals(ATTACHMENTS_FILE)) continue;
                            byte[] buf = new byte[1024];
                            String entryName = zipEntry.getName();
                            File dest_file = new File(CoreRegistry.getAttachmentsPath(), entryName);
                            dest_file.createNewFile();
                            FileOutputStream outstream = new FileOutputStream(dest_file);
                            while ((n = inputStream.read(buf, 0, 1024)) > -1) {
                                outstream.write(buf, 0, n);
                            }
                            outstream.close();
                            logger.log((IStatus)new Status(1, WorkspaceStructureImporter.class.getName(), "Attachment copied: " + entryName));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e1) {
                        logger.log((IStatus)new Status(4, "Error read attachments from '{}'", file.getAbsolutePath(), (Throwable)e1));
                        throw e1;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            logger.log((IStatus)new Status(4, "Error read zip file '{}'", file.getAbsolutePath(), (Throwable)e2));
            throw e2;
        }
    }

    public static void persistAttachments(ILog logger, AttachmentModel[] selection, File zipFile) throws Exception {
        TimeseriesServiceHelper.removeAllAttachments();
        WorkspaceStructureImporter.copyAttachmentFiles(logger, zipFile);
        AttachmentModel[] attachmentModelArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            AttachmentModel attachmentModel = attachmentModelArray[n2];
            attachmentModel.persistModel(null);
            ++n2;
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
    }

    public static Workspace importWorkspace(String xmlMessage) throws Exception {
        StringReader reader = new StringReader(xmlMessage);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Workspace.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        Workspace w4 = (Workspace)jaxbUnmarshaller.unmarshal((Reader)reader);
        return w4;
    }
}

