/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.IGraphicsElements;

public class DimensionMetadataPanel
extends Composite {
    private Dimension dimension = null;
    private String lang = null;
    private String[] columnHeaders;
    private String sortAttribute = null;
    private TableViewer tableView;
    private ConceptLabelProvider conceptLabelProvider;

    public DimensionMetadataPanel(Composite parent, Dimension dimension, String lang) {
        super(parent, 0);
        this.setBackground(SWTResourceManager.getColor(1));
        this.setBackgroundMode(2);
        this.dimension = dimension;
        this.lang = lang;
        this.getColumns();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((Layout)new GridLayout(4, false));
        Label lblDimensionLabel = new Label((Composite)this, 0);
        lblDimensionLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblDimensionLabel.setForeground(ComponentsCommons.getColor(10));
        lblDimensionLabel.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblDimensionLabel.setText(ComponentsActivator.getDefault().getLocalString("label.dimension.first.upper"));
        Label lblDimensionName = new Label((Composite)this, 0);
        lblDimensionName.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblDimensionName.setText(CoreUtils.getCurrentLang((MultilingualString)this.dimension.getName(), (String)this.lang));
        Label lblDimensionAcronymLabel = new Label((Composite)this, 0);
        lblDimensionAcronymLabel.setAlignment(131072);
        GridData gridData1 = new GridData(131072, 128, false, false, 1, 1);
        gridData1.horizontalIndent = 15;
        lblDimensionAcronymLabel.setLayoutData((Object)gridData1);
        lblDimensionAcronymLabel.setForeground(ComponentsCommons.getColor(10));
        lblDimensionAcronymLabel.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblDimensionAcronymLabel.setText(ComponentsActivator.getDefault().getLocalString("label.acronym.first.upper"));
        Label lblDimensionAcronym = new Label((Composite)this, 0);
        lblDimensionAcronym.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        lblDimensionAcronym.setText(this.dimension.getAcronym());
        Label lblDimensionDescriptionLabel = new Label((Composite)this, 0);
        lblDimensionDescriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 2));
        lblDimensionDescriptionLabel.setForeground(ComponentsCommons.getColor(10));
        lblDimensionDescriptionLabel.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblDimensionDescriptionLabel.setText(ComponentsActivator.getDefault().getLocalString("label.description.first.upper"));
        StyledText lblDimensionDescription = new StyledText((Composite)this, 72);
        GridData gd_lblDimensionDescription = new GridData(16384, 4, false, false, 3, 2);
        gd_lblDimensionDescription.widthHint = 600;
        lblDimensionDescription.setLayoutData((Object)gd_lblDimensionDescription);
        lblDimensionDescription.setText(CoreUtils.getCurrentLang((MultilingualString)this.dimension.getDescription(), (String)this.lang));
        Label lblSeparator = new Label((Composite)this, 258);
        GridData gridData3 = new GridData(4, 0x1000000, false, false, 4, 1);
        gridData3.heightHint = 5;
        gridData3.verticalIndent = 10;
        lblSeparator.setLayoutData((Object)gridData3);
        Label lblReferenceConcept = new Label((Composite)this, 0);
        lblReferenceConcept.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblReferenceConcept.setForeground(ComponentsCommons.getColor(10));
        lblReferenceConcept.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblReferenceConcept.setText(ComponentsActivator.getDefault().getLocalString("label.reference.concept"));
        Label lblConceptName = new Label((Composite)this, 0);
        lblConceptName.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblConceptName.setText(CoreUtils.getCurrentLang((MultilingualString)this.dimension.getConcept().getName(), (String)this.lang));
        Label lblConceptAcronymLabel = new Label((Composite)this, 0);
        lblConceptAcronymLabel.setAlignment(131072);
        lblConceptAcronymLabel.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblConceptAcronymLabel.setForeground(ComponentsCommons.getColor(10));
        lblConceptAcronymLabel.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblConceptAcronymLabel.setText(ComponentsActivator.getDefault().getLocalString("label.acronym.first.upper"));
        Label lblConceptAcronym = new Label((Composite)this, 0);
        lblConceptAcronym.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        lblConceptAcronym.setText(this.dimension.getConcept().getAcronym());
        String conceptDescription = CoreUtils.getCurrentLang((MultilingualString)this.dimension.getConcept().getDescription(), (String)this.lang);
        Label lblConceptDescriptionLabel = new Label((Composite)this, 0);
        lblConceptDescriptionLabel.setForeground(ComponentsCommons.getColor(10));
        lblConceptDescriptionLabel.setFont(IGraphicsElements.TAHOMA_8POINT_BOLD);
        lblConceptDescriptionLabel.setText(ComponentsActivator.getDefault().getLocalString("label.description.first.upper"));
        lblConceptDescriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 2));
        StyledText lblConceptDescription = new StyledText((Composite)this, 72);
        GridData gd_lblConceptDescription = new GridData(16384, 128, false, false, 3, 2);
        gd_lblConceptDescription.widthHint = 600;
        lblConceptDescription.setLayoutData((Object)gd_lblConceptDescription);
        lblConceptDescription.setText("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.");
        lblConceptDescription.setText(conceptDescription);
        GridData gridData6 = new GridData(16384, 128, true, true);
        gridData6.verticalSpan = 10;
        gridData6.horizontalSpan = 4;
        this.tableView = new TableViewer((Composite)this, 2048);
        this.tableView.getControl().setLayoutData((Object)gridData6);
        String[] stringArray = this.columnHeaders;
        int n = this.columnHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableView, 0);
            TableColumn tblclmn = tableViewerColumn.getColumn();
            tblclmn.setText(columnName);
            if (this.columnHeaders.length > 4) {
                tblclmn.setWidth(100);
            } else {
                tblclmn.setWidth(180);
            }
            ++n2;
        }
        Table table = this.tableView.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableView.setContentProvider((IContentProvider)new ConceptContentProvider());
        this.conceptLabelProvider = new ConceptLabelProvider();
        this.tableView.setLabelProvider((IBaseLabelProvider)this.conceptLabelProvider);
        this.tableView.setInput((Object)this.dimension.getConcept());
        if (this.sortAttribute != null) {
            this.tableView.setComparator((ViewerComparator)new DimensionViewComparator());
        }
    }

    private void getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Attribute attrib : this.dimension.getConcept().getAttributes()) {
            if (!attrib.getAcronym().equals("TAXONOMIC_CODE") && !attrib.getAcronym().equals("UN_CODE")) continue;
            columns.add(attrib.getAcronym());
            this.sortAttribute = attrib.getAcronym();
        }
        if (this.sortAttribute == null) {
            for (Attribute attrib : this.dimension.getConcept().getAttributes()) {
                if (!attrib.getAcronym().equals("CODE")) continue;
                columns.add(attrib.getAcronym());
                this.sortAttribute = attrib.getAcronym();
            }
        }
        for (Attribute attrib : this.dimension.getConcept().getAttributes()) {
            if (!attrib.getAcronym().equals("ALPHA_3_CODE")) continue;
            columns.add(attrib.getAcronym());
        }
        for (Attribute attrib : this.dimension.getConcept().getAttributes()) {
            if (attrib.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                columns.add(String.valueOf(attrib.getAcronym()) + ".EN");
                columns.add(String.valueOf(attrib.getAcronym()) + ".FR");
                columns.add(String.valueOf(attrib.getAcronym()) + ".ES");
                continue;
            }
            if (attrib.getAcronym().equals("ID") || attrib.getAcronym().equals("FID") || columns.contains(attrib.getAcronym())) continue;
            columns.add(attrib.getAcronym());
        }
        this.columnHeaders = new String[columns.size()];
        this.columnHeaders = columns.toArray(this.columnHeaders);
    }

    public TableViewer getTableView() {
        return this.tableView;
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getColumnText(ReferenceObject element, int columnIndex) {
        return this.conceptLabelProvider.getColumnText(element, columnIndex);
    }

    private class ConceptContentProvider
    implements IStructuredContentProvider {
        private ConceptContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Concept) {
                return ((Concept)inputElement).getObjects().toArray();
            }
            return new Object[0];
        }
    }

    private class ConceptLabelProvider
    implements ITableLabelProvider {
        private ConceptLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnName = DimensionMetadataPanel.this.columnHeaders[columnIndex];
            if (columnName.endsWith(".EN")) {
                String attributeName = columnName.substring(0, columnName.length() - 3);
                return ((MultilingualString)((ReferenceObject)element).getAttribute(attributeName)).getValue("en");
            }
            if (columnName.endsWith(".FR")) {
                String attributeName = columnName.substring(0, columnName.length() - 3);
                return ((MultilingualString)((ReferenceObject)element).getAttribute(attributeName)).getValue("fr");
            }
            if (columnName.endsWith(".ES")) {
                String attributeName = columnName.substring(0, columnName.length() - 3);
                return ((MultilingualString)((ReferenceObject)element).getAttribute(attributeName)).getValue("es");
            }
            Object attrib = ((ReferenceObject)element).getAttribute(columnName);
            if (attrib == null) {
                return "<Error>";
            }
            return attrib.toString();
        }
    }

    private class DimensionViewComparator
    extends ViewerComparator {
        private DimensionViewComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ReferenceObject r1 = (ReferenceObject)e1;
            ReferenceObject r2 = (ReferenceObject)e2;
            return r1.getAttribute(DimensionMetadataPanel.this.sortAttribute).toString().compareTo(r2.getAttribute(DimensionMetadataPanel.this.sortAttribute).toString());
        }
    }
}

