/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.multilingual;

import java.beans.Beans;
import java.util.Locale;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class MultilingualLabel
extends Composite {
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private MultilingualStringWrapper instance;
    private String lang;
    private CTabFolder tabFolder;
    private CTabItem[] tabitems;
    private CLabel[] labels;
    int langSize = 0;

    public MultilingualLabel(Composite parent, int style, MultilingualStringWrapper value, String lang) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.lang = lang;
        this.instance = value;
        this.langSize = MultilingualString.LANGUAGES.size();
        this.labels = new CLabel[this.langSize];
        this.tabitems = new CTabItem[this.langSize];
        this.initComponents();
    }

    public void setCommonValue(String text) {
        CLabel[] cLabelArray = this.labels;
        int n = this.labels.length;
        int n2 = 0;
        while (n2 < n) {
            CLabel label = cLabelArray[n2];
            label.setText(text);
            ++n2;
        }
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setBackgroundMode(2);
        this.tabFolder.setBackground(SWTResourceManager.getColor(1));
        this.toolkit.setBorderStyle(0);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
        this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
        this.tabFolder.setBorderVisible(true);
        int i = 0;
        while (i < this.labels.length) {
            block6: {
                this.tabitems[i] = new CTabItem(this.tabFolder, 0);
                if (!Beans.isDesignTime()) {
                    try {
                        if (JdbcResourceManager.getJdbcUrl() == null) {
                            this.tabitems[i].setText((String)MultilingualString.LANGUAGES.get(i));
                            break block6;
                        }
                        Concept concept = ReferenceServiceFactory.getService().getConcept("LANGUAGE");
                        ReferenceObject langRO = concept.getObject("ISO_2_CODE", MultilingualString.LANGUAGES.get(i));
                        this.tabitems[i].setText(CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)langRO.getAttribute("NAME")), (String)this.lang) != null ? CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)langRO.getAttribute("NAME")), (String)this.lang) : "");
                    }
                    catch (ReferenceServiceException e) {
                        ComponentsCommons.showExceptionWithStack(e);
                    }
                } else {
                    this.tabitems[i].setText("lang. " + i);
                }
            }
            this.labels[i] = new CLabel((Composite)this.tabFolder, super.getStyle());
            this.tabitems[i].setControl((Control)this.labels[i]);
            ++i;
        }
        this.tabFolder.setSelection(this.tabitems[0]);
    }

    public ReferenceObject getSelectedItemLanguage() {
        return CoreCommons.getLanguages().getObject("ISO_2_CODE", MultilingualString.LANGUAGES.get(this.tabFolder.getSelectionIndex()));
    }

    public String getSelectedItemLanguageCode() {
        return (String)MultilingualString.LANGUAGES.get(this.tabFolder.getSelectionIndex());
    }

    public MultilingualStringWrapper getInstance() {
        return this.instance;
    }

    public void setValue(MultilingualString value) {
        int i = 0;
        while (i < MultilingualString.LANGUAGES.size()) {
            this.labels[i].setText(value.getValue((String)MultilingualString.LANGUAGES.get(i)));
            ++i;
        }
    }

    public void setValue(String lang, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(lang);
        this.instance.setValue(lang, value);
        this.labels[idx].setText(value);
    }

    public void setValue(Locale locale, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(locale.getLanguage());
        this.instance.setValue(locale, value);
        this.labels[idx].setText(value);
    }

    public int getLangSize() {
        return this.langSize;
    }

    public String getText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.labels[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText();
        }
        return null;
    }

    public boolean hasText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.labels[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText() != null && !this.labels[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText().equals("");
        }
        return false;
    }
}

