/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.providers;

import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class MeasureDimensionProvidersFactory {
    private static MeasureDimensionContentProvider contentProvider;
    private static MeasureDimensionLabelProvider labelProvider;
    private static MeasureDimensionSorter sorter;

    public static MeasureDimensionContentProvider getContentProvider() {
        if (contentProvider == null) {
            contentProvider = new MeasureDimensionContentProvider();
        }
        return contentProvider;
    }

    public static MeasureDimensionLabelProvider getLabelProvider(String lang) {
        if (labelProvider == null) {
            labelProvider = new MeasureDimensionLabelProvider(lang);
        }
        return labelProvider;
    }

    public static MeasureDimensionSorter getSorter(String lang) {
        if (sorter == null) {
            sorter = new MeasureDimensionSorter(lang);
        }
        return sorter;
    }

    private static class MeasureDimensionContentProvider
    implements IStructuredContentProvider {
        private MeasureDimensionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Timeseries) {
                try {
                    Dimension omd = ((Timeseries)inputElement).getDataset().getObservedMeasureDimension();
                    Collection refset = ((Timeseries)inputElement).getAllReferencedObjects(omd);
                    return refset.toArray(new ReferenceObject[0]);
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class MeasureDimensionLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private String lang;

        public MeasureDimensionLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof ReferenceObject) {
                return CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (String)"NAME", (String)this.lang);
            }
            return null;
        }
    }

    private static class MeasureDimensionSorter
    extends ViewerComparator {
        private String lang;

        public MeasureDimensionSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ReferenceObject && e2 instanceof ReferenceObject) {
                return CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)e1), (String)"NAME", (String)this.lang).compareTo(CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)e2), (String)"NAME", (String)this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

