/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.beans.Beans;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.providers.content.MeasuresContentProvider;
import org.fao.fi.fishstat.gui.components.providers.labels.MeasuresLabelProvider;
import org.fao.fi.fishstat.gui.components.providers.sorters.MeasuresSorter;

public class TimeSegmentSelector
extends Composite {
    private Timeseries timeseries;
    private Table table;
    private CheckboxTableViewer checkboxTableViewer;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Button btnAll;
    private Button btnNone;

    public TimeSegmentSelector(Composite parent, int style, Timeseries timeseries, boolean allchecked) {
        super(parent, style);
        this.timeseries = timeseries;
        this.initComponents(allchecked);
    }

    private void initComponents(boolean allchecked) {
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        this.setLayout((Layout)gridLayout);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)67586);
        this.checkboxTableViewer.setAllChecked(false);
        this.table = this.checkboxTableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setBackground(SWTResourceManager.getColor(254, 255, 255));
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 148;
        gridData.widthHint = 308;
        this.table.setLayoutData((Object)gridData);
        if (!Beans.isDesignTime()) {
            this.checkboxTableViewer.setContentProvider((IContentProvider)new MeasuresContentProvider());
            this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new MeasuresLabelProvider(this.timeseries.getTimeResolution()));
            this.checkboxTableViewer.setComparator((ViewerComparator)new MeasuresSorter());
            this.checkboxTableViewer.setInput((Object)this.timeseries);
        }
        this.btnAll = this.formToolkit.createButton((Composite)this, ComponentsActivator.getDefault().getLocalString("label.all.first.upper"), 0);
        this.btnAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSegmentSelector.this.checkboxTableViewer.setCheckedElements((Object[])TimeSegmentSelector.this.timeseries.getObservationPeriods().toArray(new ObservationPeriod[0]));
            }
        });
        GridData gridData_1 = new GridData(4, 4, false, false, 1, 1);
        gridData_1.widthHint = 74;
        this.btnAll.setLayoutData((Object)gridData_1);
        this.btnNone = this.formToolkit.createButton((Composite)this, ComponentsActivator.getDefault().getLocalString("label.none.first.upper"), 0);
        this.btnNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSegmentSelector.this.checkboxTableViewer.setCheckedElements((Object[])new ObservationPeriod[0]);
            }
        });
        this.btnNone.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (allchecked) {
            this.checkboxTableViewer.setCheckedElements((Object[])this.timeseries.getObservationPeriods().toArray(new ObservationPeriod[0]));
        }
    }

    protected void checkSubclass() {
    }

    public void syncroPanel(List<ObservationPeriod> periods) {
        if (periods == null) {
            this.checkboxTableViewer.setCheckedElements((Object[])this.timeseries.getObservationPeriods().toArray(new ObservationPeriod[0]));
        } else {
            this.checkboxTableViewer.setCheckedElements((Object[])periods.toArray(new ObservationPeriod[0]));
        }
    }

    public List<ObservationPeriod> getChecked() {
        Vector<ObservationPeriod> res = new Vector<ObservationPeriod>(this.checkedSize());
        Object[] objectArray = this.checkboxTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object op = objectArray[n2];
            res.add((ObservationPeriod)op);
            ++n2;
        }
        return res;
    }

    public int checkedSize() {
        return this.checkboxTableViewer.getCheckedElements().length;
    }
}

