/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.IGraphicsElements;

public class DatasetMetadataUpperComposite
extends Composite {
    private Label lblName;
    private Label lblAcronym;
    private Label lblDescription;
    private Link lblUrl;
    private String url;
    private Label lblDate;
    private Label lblSource;

    public DatasetMetadataUpperComposite(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    private void initComponents() {
        this.setFont(IGraphicsElements.TAHOMA_7POINT_NORMAL);
        this.setBackgroundMode(2);
        this.setBackground(SWTResourceManager.getColor(1));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.setLayoutData(gridData);
        Label lblNameLabel = new Label((Composite)this, 0);
        lblNameLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblNameLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblNameLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblNameLabel.setText(Activator.getLocalString("label.name.first.upper"));
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblName.setForeground(ComponentsCommons.getColor((int)2));
        this.lblName.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        this.lblName.setLayoutData((Object)new GridData(0, 4, true, false, 3, 1));
        Label lblAcronymLabel = new Label((Composite)this, 0);
        lblAcronymLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblAcronymLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblAcronymLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblAcronymLabel.setText(Activator.getLocalString("label.acronym.first.upper"));
        this.lblAcronym = new Label((Composite)this, 0);
        this.lblAcronym.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblAcronym.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        this.lblAcronym.setForeground(ComponentsCommons.getColor((int)2));
        Label lblDateLabel = new Label((Composite)this, 0);
        lblDateLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblDateLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblDateLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblDateLabel.setText(Activator.getLocalString("label.date.first.upper"));
        GridData gdLblDateLabel = new GridData();
        gdLblDateLabel.horizontalIndent = 30;
        lblDateLabel.setLayoutData((Object)gdLblDateLabel);
        this.lblDate = new Label((Composite)this, 256);
        this.lblDate.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblDate.setForeground(ComponentsCommons.getColor((int)2));
        this.lblDate.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        Label lblSourceLabel = new Label((Composite)this, 0);
        lblSourceLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblSourceLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblSourceLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblSourceLabel.setText(Activator.getLocalString("label.data.source"));
        this.lblSource = new Label((Composite)this, 0);
        this.lblSource.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblSource.setForeground(ComponentsCommons.getColor((int)2));
        this.lblSource.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        this.lblSource.setLayoutData((Object)new GridData(0, 4, true, false, 3, 1));
        Label lblUrlLabel = new Label((Composite)this, 0);
        lblUrlLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblUrlLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblUrlLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblUrlLabel.setText(Activator.getLocalString("label.url.all.upper"));
        this.lblUrl = new Link((Composite)this, 0);
        this.lblUrl.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblUrl.setForeground(ComponentsCommons.getColor((int)2));
        this.lblUrl.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        this.lblUrl.setLayoutData((Object)new GridData(0, 4, true, false, 3, 1));
        this.lblUrl.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (DatasetMetadataUpperComposite.this.url != null) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(DatasetMetadataUpperComposite.this.url));
                    }
                    catch (Exception ex) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "Was not able to open " + DatasetMetadataUpperComposite.this.url + " in external browser ", (Throwable)ex));
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Label lblDescriptionLabel = new Label((Composite)this, 0);
        lblDescriptionLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
        lblDescriptionLabel.setForeground(ComponentsCommons.getColor((int)10));
        lblDescriptionLabel.setFont(IGraphicsElements.TAHOMA_7POINT_BOLD);
        lblDescriptionLabel.setText(Activator.getLocalString("label.description.first.upper"));
        this.lblDescription = new Label((Composite)this, 64);
        this.lblDescription.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lblDescription.setForeground(ComponentsCommons.getColor((int)2));
        this.lblDescription.setFont(IGraphicsElements.TAHOMA_8POINT_NORMAL);
        this.lblDescription.setLayoutData((Object)new GridData(0, 68, true, false, 3, 5));
    }

    public void renderDataset(Dataset ds) {
        this.url = null;
        if (ds != null) {
            this.lblName.setText(CoreUtils.getCurrentLang((MultilingualString)ds.getName(), (String)Activator.getLanguage()));
            this.lblAcronym.setText(ds.getAcronym());
            this.lblDescription.setText(CoreUtils.getCurrentLang((MultilingualString)ds.getDescription(), (String)Activator.getLanguage()));
            if (ds.getUrl() != null) {
                this.url = ds.getUrl();
                this.lblUrl.setText("<a href=\"" + ds.getUrl() + "\">" + ds.getUrl() + "</a>");
            } else {
                this.lblUrl.setText("");
            }
            this.lblDate.setText(ds.getVersion().getDate() != null ? ds.getVersion().getDate().toString() : "");
            this.lblSource.setText(ds.getDataSource() != null ? ds.getDataSource().getName() : "");
            this.layout(true);
        } else {
            this.lblName.setText("");
            this.lblAcronym.setText("");
            this.lblDescription.setText("");
            this.lblUrl.setText("");
            this.lblDate.setText("");
            this.lblSource.setText("");
            this.layout(true);
        }
    }
}

