/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.topothers;

import java.beans.Beans;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.topothers.TopOtherComposite;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class TopOtherDialog
extends TitleAreaDialog
implements IFSActions,
IGuiPreferencesConstants {
    private TopCriteriaWrapper topCriteriaWrapper;
    private TopOtherComposite topOtherComposite;
    private CoreRegistry registry = GuiCoreActivator.getDefault().getRegistry();
    private boolean sameForRelatives = Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series");

    public TopOtherDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(255, 255, 255));
        Composite area = (Composite)super.createDialogArea(parent);
        area.setBackground(SWTResourceManager.getColor(1));
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(1808));
        if (Beans.isDesignTime()) {
            new TopOtherComposite(container, null);
        } else {
            Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            this.topCriteriaWrapper = session.hasTopCriteriaRequest() ? session.getTopOthersRequest() : new TopCriteriaWrapper(session);
            this.topOtherComposite = new TopOtherComposite(container, this.topCriteriaWrapper);
            this.setTitle(Activator.getPluginBundle().getString("timeseries.topothers.dialog.title"));
            this.setMessage(Activator.getPluginBundle().getString("timeseries.topothers.dialog.subtitle"));
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(Activator.getImage("icons/actions/topother.png"));
        newShell.setText(Activator.getPluginBundle().getString("timeseries.topothers.dialog.bartitle"));
    }

    protected Point getInitialSize() {
        return Activator.windowsScaling(550, 450);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (buttonId == 0 && this.topOtherComposite.applyData(this.topCriteriaWrapper)) {
                if (!this.topCriteriaWrapper.hasCriteriaType()) {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, monitor -> this.registry.removeActionRequest(4, this.sameForRelatives, monitor));
                } else {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, monitor -> this.registry.processActionRequest((IActionRequestWrapper)this.topCriteriaWrapper, this.sameForRelatives, monitor));
                }
                super.buttonPressed(buttonId);
            }
            if (buttonId == 1) {
                super.buttonPressed(buttonId);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "activating top/other", (Throwable)e));
        }
    }
}

