/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationDialog;

public class GroupByHandler
extends AbstractHandler
implements IHandler {
    public static final String ID = "org.fao.fi.fishstat.gui.command.dynamic.contextual.groupby";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String column_string = event.getParameter("org.fao.fi.fishstat.gui.command.dynamic.contextual.groupby.param.column");
        String parent_acronym = event.getParameter("org.fao.fi.fishstat.gui.command.dynamic.contextual.groupby.param.parent");
        Integer descId = Integer.parseInt(column_string) - 1;
        if (descId >= 0) {
            Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            FSDimensionColumnDescriptor descriptor = (FSDimensionColumnDescriptor)session.getLastFocusEntity().getColumnDescriptor();
            Dimension dimension = descriptor.getDimension();
            Concept aggregator = ReferenceServiceFactory.getService().getConcept(parent_acronym);
            AggregationWrapper agg = session.hasAggregationRequest() ? session.getAggregationRequest() : new AggregationWrapper(session);
            agg.getDimensionAggregation(dimension.getConcept().getAcronym()).setBasicConceptAggregation(aggregator);
            AggregationDialog.modifyAggregation(agg);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

