/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationAdvisor;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationDialog;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.workspaces.WorkspacesBrowserDialog;

public class SwitchWorkspaceHandler
extends AbstractHandler
implements IHandler,
IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.dynamic.switch.workspace";
    public static final String WKS_PARAMTER = "org.fao.fi.fishstat.gui.dataset.switch.workspace.parameter.id";
    private String wsPath;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setWorkspacePath(event.getParameter(WKS_PARAMTER));
        if (this.hasWorkspaceUpdate(this.wsPath)) {
            WorkspacesBrowserDialog dlg = new WorkspacesBrowserDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dlg.open();
            return null;
        }
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), () -> ApplicationAdvisor.workspaceOpen(this.getWorkspacePath()));
        try {
            ICommandService commandService;
            Command command;
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.open.workspace.browser") && GuiCoreActivator.getDefault().getRegistry().getOpenSessionsSize() == 0 && (command = (commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("org.fao.fi.fishstat.gui.command.dataset.open")).isEnabled()) {
                commandService.getCommand("org.fao.fi.fishstat.gui.command.dataset.open").executeWithChecks(new ExecutionEvent());
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AggregationDialog.class.getName(), "open workspace failed", (Throwable)e));
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("switchworkspacehandler.newdata.openerror.title"), (String)Activator.getPluginBundle().getString("switchworkspacehandler.newdata.openerror.message"));
            System.exit(1);
        }
        return null;
    }

    private boolean hasWorkspaceUpdate(String wsPath) {
        AutoUpdateMain aa = ApplicationAdvisor.getAutoUpdate();
        if (aa == null) {
            return false;
        }
        List<AutoUpdateWks> aaWorkspaces = aa.getAutoupdateWorkspaces();
        if (aaWorkspaces.isEmpty()) {
            return false;
        }
        WorkspaceModelImpl wmd = null;
        try {
            wmd = new WorkspaceModelImpl(new File(wsPath));
        }
        catch (Exception exception) {
            return false;
        }
        for (AutoUpdateWks aaWorkspace : aaWorkspaces) {
            MessageDialog dialog;
            VersionId aaVersion = new VersionId(aaWorkspace.getVersion());
            if (!aaWorkspace.getAcronym().equals(wmd.getAcronym()) || aaVersion.compareTo(wmd.getVersion()) <= 0 || (dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getPluginBundle().getString("switchworkspacehandler.newdata.title"), null, MessageFormat.format(Activator.getPluginBundle().getString("switchworkspacehandler.newdata.message"), wmd.getDescription().getValue(CoreCommons.LOCALE2), wmd.getVersion().toString(), aaWorkspace.getDescription(), aaWorkspace.getVersion()), 3, new String[]{Activator.getPluginBundle().getString("switchworkspacehandler.newdata.yes"), MessageFormat.format(Activator.getPluginBundle().getString("switchworkspacehandler.newdata.no"), wmd.getVersion().toString())}, 0)).open() != 0) continue;
            return true;
        }
        return false;
    }

    public String getWorkspacePath() {
        return this.wsPath;
    }

    public void setWorkspacePath(String wsPath) {
        this.wsPath = wsPath;
    }
}

