/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.view;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.management.SingleAttachmentDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;

public class ShowMapHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.view.showmap";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session != null) {
            for (Attachment attachment : session.getDataset().getAttachments()) {
                if (!attachment.getType().equals((Object)AttachmentType.BITMAP) && !attachment.getType().equals((Object)AttachmentType.JPG)) continue;
                SingleAttachmentDialog singleAttachmentDialog = new SingleAttachmentDialog(Display.getCurrent().getActiveShell(), attachment);
                singleAttachmentDialog.open();
            }
        }
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        Session session;
        if (wsm.hasCurrentWorkspace() && GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() >= 1 && (session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus()) != null) {
            for (Attachment attachment : session.getDataset().getAttachments()) {
                if (!attachment.getType().equals((Object)AttachmentType.BITMAP) && !attachment.getType().equals((Object)AttachmentType.JPG)) continue;
                this.setBaseEnabled(true);
                return;
            }
        }
        this.setBaseEnabled(false);
    }
}

