/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.dataexport;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.preferences.dataexport.DataExportPreferencesPanel;

public class CsvAndClipboardDataExport
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
    private DataExportPreferencesPanel preferencesPanel;
    private ExportSettings exportSettings;
    private Button btnCheckButton;

    public CsvAndClipboardDataExport() {
        this.setTitle(Activator.getPluginBundle().getString("preferences.data.export.csv.window.title"));
        this.setMessage(Activator.getPluginBundle().getString("preferences.data.export.csv.window.subtitle"));
    }

    public Control createContents(Composite parent) {
        this.exportSettings = new ExportSettings(this.ps);
        Composite container = this.createPanel(parent);
        this.syncroPanel();
        return container;
    }

    private Composite createPanel(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpExportPreferences = new Group(container, 0);
        grpExportPreferences.setBackgroundMode(2);
        grpExportPreferences.setLayoutData((Object)new GridData(4, 128, true, false, 1, 5));
        grpExportPreferences.setLayout((Layout)new GridLayout(1, false));
        this.preferencesPanel = new DataExportPreferencesPanel((Composite)grpExportPreferences, this.exportSettings);
        this.btnCheckButton = new Button(container, 32);
        this.btnCheckButton.setText(Activator.getPluginBundle().getString("preferences.data.export.csv.adjust.label"));
        this.btnCheckButton.setToolTipText(Activator.getPluginBundle().getString("preferences.data.export.csv.adjust.tooltip"));
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        this.preferencesPanel.applyData();
        this.ps.setValue("export.csv.exportheaders", this.exportSettings.isExportHeaders());
        this.ps.setValue("export.csv.splitcolumns", this.exportSettings.isSplitSymbols());
        this.ps.setValue("export.csv.symbheaders", this.exportSettings.getSymbolHeader());
        this.ps.setValue("export.csv.nosymbols", this.exportSettings.isNoSymbols());
        this.ps.setValue("export.csv.showselection", this.exportSettings.isShowSelection());
        this.ps.setValue("export.csv.exporttotals", this.exportSettings.isExportTotals());
        this.ps.setValue("export.csv.askconfirm", this.btnCheckButton.getSelection());
        this.ps.setValue("export.csv.exportcitation", this.exportSettings.isExportCitation());
        try {
            ((IPersistentPreferenceStore)this.ps).save();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "saving preferences", (Throwable)e));
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.exportSettings.setExportHeaders(this.ps.getDefaultBoolean("export.csv.exportheaders"));
        this.exportSettings.setSplitSymbols(this.ps.getDefaultBoolean("export.csv.splitcolumns"));
        this.exportSettings.setSymbolHeader(this.ps.getDefaultString("export.csv.symbheaders"));
        this.exportSettings.setNoSymbols(this.ps.getDefaultBoolean("export.csv.nosymbols"));
        this.exportSettings.setShowSelection(this.ps.getDefaultBoolean("export.csv.showselection"));
        this.exportSettings.setExportTotals(this.ps.getDefaultBoolean("export.csv.exporttotals"));
        this.exportSettings.setExportCitation(this.ps.getDefaultBoolean("export.csv.exportcitation"));
        this.preferencesPanel.syncroPanel();
        this.btnCheckButton.setSelection(this.ps.getDefaultBoolean("export.csv.askconfirm"));
    }

    protected void syncroPanel() {
        this.preferencesPanel.syncroPanel();
        this.btnCheckButton.setSelection(this.ps.getBoolean("export.csv.askconfirm"));
    }
}

