/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.calcmesaures;

import java.beans.Beans;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.composites.FunctionParameterEditor;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;

public class FunctionParametersPanel
extends Composite {
    private Set<ParameterWrapper> parameterWrappers;
    private Vector<FunctionParameterEditor> panels;

    public FunctionParametersPanel(Composite parent, int style, Set<ParameterWrapper> params) {
        super(parent, style);
        this.parameterWrappers = params;
        if (!Beans.isDesignTime()) {
            this.panels = new Vector(params.size());
            if (params.size() > 0) {
                for (ParameterWrapper pw : params) {
                    this.panels.add(new FunctionParameterEditor((Composite)this, pw, Activator.getLanguage()));
                }
            }
        }
        this.initComponents();
    }

    public FunctionParametersPanel(Composite parent, int style, Function function) {
        super(parent, style);
        this.parameterWrappers = function.getParameters() == null ? null : new TreeSet();
        this.panels = new Vector();
        if (!Beans.isDesignTime() && function.getParameters().size() > 0) {
            Parameter[] parameters = function.getParameters().toArray(new Parameter[0]);
            int i = 0;
            while (i < parameters.length) {
                ParameterWrapper pw = new ParameterWrapper(parameters[i], null);
                this.panels.add(new FunctionParameterEditor((Composite)this, pw, Activator.getLanguage()));
                this.parameterWrappers.add(pw);
                ++i;
            }
        }
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
    }

    protected void checkSubclass() {
    }

    public void syncroPanel() {
        for (FunctionParameterEditor editor : this.panels) {
            editor.syncroPanel();
        }
    }

    public void applyData() {
        for (FunctionParameterEditor editor : this.panels) {
            editor.applyData();
        }
    }

    public ParameterWrapper[] getParameterWrappers() {
        ParameterWrapper[] result = new ParameterWrapper[this.panels.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.panels.get(i).getParameterWrapper();
            ++i;
        }
        return result;
    }

    public boolean isAllValid() {
        boolean allValid = true;
        for (ParameterWrapper pw : this.parameterWrappers) {
            boolean bl = allValid = allValid && pw.isValid();
        }
        return allValid;
    }
}

