/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.selection;

import java.util.Collection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.properties.dataset.selection.DimensionSelectionComposite;

public class DatasetSelectionComposite
extends Composite {
    private TimeSeriesProperties properties;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Section sctnDimensions;
    private CTabFolder tabFolder;

    public DatasetSelectionComposite(Composite parent, int style, TimeSeriesProperties p, int selection) {
        super(parent, style);
        this.properties = p;
        this.initComponents(selection);
    }

    private void initComponents(int selection) {
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        this.sctnDimensions = this.toolkit.createSection((Composite)this, 322);
        this.sctnDimensions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.toolkit.paintBordersFor((Composite)this.sctnDimensions);
        this.sctnDimensions.setText(Activator.getLocalString("label.dimensions.first.upper"));
        this.tabFolder = new CTabFolder((Composite)this.sctnDimensions, 0);
        this.tabFolder.setUnselectedImageVisible(false);
        this.tabFolder.setUnselectedCloseVisible(false);
        this.toolkit.adapt((Composite)this.tabFolder);
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.sctnDimensions.setClient((Control)this.tabFolder);
        this.tabFolder.setSelectionBackground(ComponentsCommons.getColor((int)32));
        if (this.properties != null) {
            this.createDimensionsExpandItem();
            this.tabFolder.setSelection(selection);
        }
    }

    private void createDimensionsExpandItem() {
        Collection dimensionsProperties = this.properties.getDatasetProperties().getDimensionsProperties();
        for (DimensionProperties dimensionProperties : dimensionsProperties) {
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            try {
                tabItem.setText(CoreUtils.getCurrentLangName((Object)dimensionProperties.getDimension(), (String)Activator.getLanguage()));
            }
            catch (Exception e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            tabItem.setControl((Control)new DimensionSelectionComposite((Composite)this.tabFolder, 0, dimensionProperties));
        }
    }
}

