/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.GuiCommons;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.YearDateComposite;

public class GrandTotalsView
extends ViewPart
implements Observer {
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.grandtotals";
    private ScrolledComposite scrolledComposite;
    private Composite parent;
    private YearDateComposite[] cells;
    private Composite panel;
    private ReferenceObject measure;
    private GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();

    public GrandTotalsView() {
        this.session.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.initializeToolBar();
        this.scrolledComposite = this.createScrolledComposite();
        this.panel = this.createPanel();
        this.measure = this.calculateMeasureObject((Session)this.session, this.getViewSite().getSecondaryId());
    }

    public void populateView() {
        if (this.measure != null) {
            StringBuilder partName = new StringBuilder(30);
            partName.append(GuiCommons.getLocalizedValue(this.session.getDataset().getName()));
            partName.append(" - ");
            partName.append(GuiCommons.getLocalizedValue(this.measure.getAttribute(this.measure.getConcept().getNameAttribute())));
            this.setPartName(partName.toString());
        }
        Display.getDefault().syncExec(() -> {
            if (!this.panel.isDisposed() && !this.scrolledComposite.isDisposed()) {
                this.session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
                this.removeCells();
                if (this.session != null) {
                    TimeSeriesProperties properties = this.session.getTimeseriesProperties();
                    this.cells = new YearDateComposite[properties.getPeriodsSize()];
                    int i = 0;
                    while (i < this.cells.length) {
                        this.cells[i] = new YearDateComposite(this.panel, properties.getPeriod(i).getISO8601());
                        ++i;
                    }
                }
                this.scrolledComposite.layout();
                this.panel.layout();
            }
        });
    }

    private void removeCells() {
        if (this.cells != null) {
            Display.getDefault().syncExec(() -> {
                int i = 0;
                while (i < this.cells.length) {
                    if (this.cells[i] != null && !this.cells[i].isDisposed()) {
                        this.cells[i].dispose();
                    }
                    ++i;
                }
                this.panel.layout();
            });
        }
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    public void loadTotalsCells() {
        if (this.session == null) {
            return;
        }
        if (!this.scrolledComposite.isDisposed()) {
            if (this.panel.isDisposed()) {
                this.panel = this.createPanel();
            }
            if (this.cells == null || this.cells.length > 0 && this.cells[0].isDisposed()) {
                this.populateView();
            }
            TimeSeriesProperties properties = this.session.getTimeseriesProperties();
            ObservationSeries totals = this.session.getLastResult().getTotals(this.measure);
            Display.getDefault().syncExec(() -> {
                this.removeCells();
                this.cells = new YearDateComposite[properties.getPeriodsSize()];
                int i = 0;
                while (i < this.cells.length) {
                    this.cells[i] = new YearDateComposite(this.panel, properties.getPeriod(i).getISO8601());
                    ++i;
                }
                try {
                    i = 0;
                    while (i < properties.getPeriodsSize()) {
                        Measure m = totals.getMeasure(properties.getPeriod(i));
                        this.cells[i].setMeasure(m);
                        this.cells[i].layout();
                        ++i;
                    }
                }
                catch (TimeseriesServiceException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "building cells", (Throwable)e));
                }
                this.scrolledComposite.layout();
                this.panel.layout();
            });
        }
    }

    public ReferenceObject getMeasure() {
        return this.measure;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Session) {
            this.populateView();
            this.loadTotalsCells();
        }
    }

    public void dispose() {
        this.session.setCalcGrandTotals(false);
        ApplicationWorkbenchAdvisor.getApplicationAdvisor().hideAllGrandTotalViews();
    }

    private ReferenceObject calculateMeasureObject(Session session, String viewUUID) {
        if (viewUUID.endsWith("-[unique]")) {
            return ReferenceObject.ALL;
        }
        for (ReferenceObject aMeasure : session.getTimeseries().getObsMeasures()) {
            if (!viewUUID.endsWith(aMeasure.getId().toString())) continue;
            return aMeasure;
        }
        return null;
    }

    private ScrolledComposite createScrolledComposite() {
        ScrolledComposite res = new ScrolledComposite(this.parent, 512);
        Display.getDefault().syncExec(() -> {
            res.setAlwaysShowScrollBars(false);
            res.setMinSize(400, 100);
            res.setExpandHorizontal(true);
            res.setExpandVertical(true);
        });
        return res;
    }

    private Composite createPanel() {
        Composite res = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)res);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 3;
        rowLayout.marginRight = 8;
        rowLayout.marginLeft = 15;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.pack = false;
        res.setLayout((Layout)rowLayout);
        return res;
    }
}

