/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.io.Serializable;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class AttachmentImpl
implements Attachment,
Serializable {
    private static final long serialVersionUID = 453931043867705604L;
    private Object attachmentDto;
    private Identifier identifier;

    public AttachmentImpl(Object attachmentDto) throws TimeseriesServiceException {
        try {
            if (attachmentDto == null) {
                throw new IllegalArgumentException("Expecting not null dataset extension DTO");
            }
            this.attachmentDto = attachmentDto;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)attachmentDto));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to instantiate the dataset extension", e);
        }
    }

    public Version getVersion() throws TimeseriesServiceException {
        try {
            return VersionHelper.getVersion((Object)this.attachmentDto);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get version", e);
        }
    }

    public void setVersion(Version version) throws TimeseriesServiceException {
        try {
            VersionHelper.setVersion((Object)this.attachmentDto, (Version)version);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set version", e);
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public String getAcronym() {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.attachmentDto, (String)"ACRONYM");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the acronym", e);
        }
    }

    @Override
    public MultilingualString getName() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.attachmentDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the name", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.attachmentDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the name", e);
        }
    }

    @Override
    public MultilingualString getDescription() throws TimeseriesServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.attachmentDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the description", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws TimeseriesServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.attachmentDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the description", e);
        }
    }

    @Override
    public Dataset getDataset() {
        try {
            return DatasetFactory.instance().getDataset(IdentifierFactory.instance((String)Commons.getDTOAttributeByAcronym((Object)this.attachmentDto, (String)"DATASET_ID").toString()));
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the mime type", e);
        }
    }

    @Override
    public AttachmentType getType() {
        try {
            return AttachmentType.valueOf(Commons.getDTOAttributeByAcronym((Object)this.attachmentDto, (String)"TYPE_ATTACHMENT").toString());
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the attachment type", e);
        }
    }

    @Override
    public void setType(AttachmentType type) {
        try {
            Commons.setDTOAttribute((Object)this.attachmentDto, (String)"TYPE_ATTACHMENT", (Object)type.toString(), String.class);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the attachment type ", e);
        }
    }

    @Override
    public String getMimeType() {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.attachmentDto, (String)"MIME_TYPE");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the mime type", e);
        }
    }

    @Override
    public void setMimeType(String mimeType) {
        try {
            Commons.setDTOAttribute((Object)this.attachmentDto, (String)"MIME_TYPE", (Object)mimeType, String.class);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the mime type", e);
        }
    }

    @Override
    public MultilingualString getFileName() {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.attachmentDto, (String)"SOURCE_FILE_NAME");
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the attachment file name", e);
        }
    }

    @Override
    public void setFileName(MultilingualString name) {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.attachmentDto, (String)"SOURCE_FILE_NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to set the attachment file name", e);
        }
    }

    private void update() throws TimeseriesServiceException {
        try {
            TimeseriesServiceHelper.getTsmDatasetAttachmentDao().update(Commons.getDTOPk((Object)this.attachmentDto), this.attachmentDto);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to update dataset extension: " + e.getMessage(), e);
        }
    }
}

