/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.status;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.SDMXMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;

public class MeasureStatusCalculatorFAO
implements MeasureStatusCalculator {
    private Map<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>> statusMap = new HashMap<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>>();

    @Override
    public void reset() {
        if (this.statusMap != null) {
            this.statusMap.clear();
        }
    }

    @Override
    public void calculate(ObservationSeries aggregated, ObservationSeries series) {
        Map<ObservationPeriod, Measure> series_measures = series.getMeasures();
        Map<ObservationPeriod, Measure> aggregated_measures = aggregated.getMeasures();
        MultiReferenceObject multikey = aggregated.getKeys();
        Map<ObservationPeriod, DoubleValue> status_row = this.statusMap.get(multikey);
        if (status_row == null) {
            status_row = new HashMap<ObservationPeriod, DoubleValue>();
            this.statusMap.put(multikey, status_row);
        }
        for (ObservationPeriod period : series.getTimeseries().getObservationPeriods()) {
            Measure observation_measure = series_measures.get(period);
            Measure aggregated_measure = aggregated_measures.get(period);
            DoubleValue value = status_row.computeIfAbsent(period, k -> new DoubleValue());
            this.aggregate(aggregated_measure, observation_measure, value);
        }
    }

    private void aggregate(Measure aggregated, Measure measure, DoubleValue value) {
        if (aggregated == null || measure == null) {
            throw new IllegalArgumentException("Measure can not be null");
        }
        MeasureStatus aggregated_symbol = aggregated.getStatus();
        MeasureStatus measure_symbol = measure.getStatus();
        if (aggregated_symbol == null) {
            aggregated_symbol = SDMXMeasureStatus.OFFICIAL;
        }
        if (measure_symbol == null) {
            measure_symbol = SDMXMeasureStatus.OFFICIAL;
        }
        if (aggregated.getValue() == 0.0 && measure.getValue() == 0.0) {
            if (aggregated_symbol.equals(SDMXMeasureStatus.NEGLIBILE) || measure_symbol.equals(SDMXMeasureStatus.NEGLIBILE)) {
                aggregated.setStatus(SDMXMeasureStatus.NEGLIBILE);
            } else if (aggregated_symbol.equals(SDMXMeasureStatus.UNAVAILABLE) || measure_symbol.equals(SDMXMeasureStatus.UNAVAILABLE)) {
                aggregated.setStatus(SDMXMeasureStatus.UNAVAILABLE);
            } else if (aggregated_symbol.equals(SDMXMeasureStatus.ZERO) || measure_symbol.equals(SDMXMeasureStatus.ZERO)) {
                aggregated.setStatus(SDMXMeasureStatus.ZERO);
            } else {
                aggregated.setStatus(SDMXMeasureStatus.OFFICIAL);
            }
        } else {
            value.addValue(measure.getValue(), measure_symbol);
            aggregated.setStatus(value.getStatus());
        }
    }

    final class DoubleValue {
        private double estimate = 0.0;
        private double official = 0.0;
        private double mirrored = 0.0;
        private double imputed = 0.0;

        public MeasureStatus getStatus() {
            if (Math.abs(this.estimate) > Math.abs(Math.max(Math.max(this.official, this.mirrored), this.imputed))) {
                return SDMXMeasureStatus.ESTIMATE;
            }
            if (Math.abs(this.mirrored) > Math.abs(Math.max(Math.max(this.estimate, this.official), this.imputed))) {
                return SDMXMeasureStatus.MIRRORED;
            }
            if (Math.abs(this.imputed) > Math.abs(Math.max(Math.max(this.estimate, this.official), this.mirrored))) {
                return SDMXMeasureStatus.IMPUTED;
            }
            return SDMXMeasureStatus.OFFICIAL;
        }

        public void addValue(double value, MeasureStatus measure_symbol) {
            if (measure_symbol.equals(SDMXMeasureStatus.ESTIMATE)) {
                this.estimate += value;
            } else if (measure_symbol.equals(SDMXMeasureStatus.MIRRORED)) {
                this.mirrored += value;
            } else if (measure_symbol.equals(SDMXMeasureStatus.IMPUTED)) {
                this.imputed += value;
            } else {
                this.official += value;
            }
        }
    }
}

