/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class ConceptProperties
implements Cloneable,
IFSActions {
    public static final int DESCRIPTOR = 1;
    public static final int SELECTOR = 2;
    protected String id;
    protected int type;
    protected DimensionProperties dimensionProperties;
    protected Concept concept;
    protected Attribute attribute;
    protected Attribute alternate;
    protected Relationship relationship;
    protected Map<String, String> parentAttributes = new HashMap<String, String>();

    public ConceptProperties(DimensionProperties p, String id, int type, Concept c) {
        this.id = id;
        this.concept = c;
        this.type = type;
        this.dimensionProperties = p;
        this.createDefaults(p.getDatasetProperties().getPreferenceStore(), true);
    }

    public Dimension getDimension() {
        return this.dimensionProperties.getDimension();
    }

    public DimensionProperties getDimensionProperties() {
        return this.dimensionProperties;
    }

    public int getDimensionIdx() {
        return this.dimensionProperties.getDimensionIdx();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
        this.dimensionProperties.setChanged();
        this.dimensionProperties.notifyObservers();
    }

    public int getType() {
        return this.type;
    }

    public Attribute getAlternate() {
        return this.alternate;
    }

    public boolean hasAlternate() {
        return this.alternate != null;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.relationship = concept.equals(this.dimensionProperties.dimension.getConcept()) ? null : CoreUtils.getRelationship((Concept)concept, (Concept)this.dimensionProperties.dimension.getConcept());
        this.createDefaults(null, false);
        this.dimensionProperties.setChanged();
        this.dimensionProperties.notifyObservers();
    }

    public Concept getConcept() {
        return this.concept;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null;
    }

    public String getConceptAcronym() {
        return this.concept.getAcronym();
    }

    public void setAlternate(Attribute alternate) {
        this.alternate = alternate;
        this.dimensionProperties.setChanged();
        this.dimensionProperties.notifyObservers();
    }

    public void setParentAttribute(String concept, String attribute) {
        this.parentAttributes.put(concept, attribute);
    }

    public boolean hasParentAttribute(String concept) {
        return this.parentAttributes.containsKey(concept);
    }

    public String getParentAttribute(String concept) {
        return this.parentAttributes.get(concept);
    }

    private void createDefaults(PreferenceStore store, boolean persistence) {
        this.attribute = this.concept.getNameAttribute();
        if (this.attribute != null && persistence) {
            store.setDefault(String.valueOf(this.id) + ".attribute", this.attribute.getAcronym());
        }
        this.alternate = this.concept.getAcronym().contains("SPECIES") ? this.concept.getAttribute("SCIENTIFIC_NAME") : null;
    }

    protected ConceptProperties loadProperties(PreferenceStore store) {
        try {
            String conceptID = null;
            if (store.contains(String.valueOf(this.id) + ".concept")) {
                conceptID = store.getString(String.valueOf(this.id) + ".concept");
            }
            if (conceptID != null && !conceptID.equals(this.concept.getAcronym())) {
                List childs = CoreUtils.getChilds((Concept)this.dimensionProperties.getDimensionConcept());
                for (Concept child_concept : childs) {
                    if (!child_concept.getAcronym().equals(conceptID)) continue;
                    this.setConcept(child_concept);
                }
            }
            String attributeID = null;
            attributeID = store.contains(String.valueOf(this.id) + ".attribute") ? store.getString(String.valueOf(this.id) + ".attribute") : store.getDefaultString(String.valueOf(this.id) + ".attribute");
            String alternateID = null;
            if (store.contains(String.valueOf(this.id) + ".alternate")) {
                alternateID = store.getString(String.valueOf(this.id) + ".alternate");
            }
            this.attribute = this.concept.getAttribute(attributeID);
            if (alternateID != null) {
                this.alternate = this.concept.getAttribute(alternateID);
            }
            if (store.contains(String.valueOf(this.id) + ".parents")) {
                try {
                    this.processParentString(store.getString(String.valueOf(this.id) + ".parents"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.type == 1) {
                this.dimensionProperties.getDatasetProperties().addAction(21);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private void processParentString(String parentString) {
        String[] couples;
        String[] stringArray = couples = parentString.split("#");
        int n = couples.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] couple = string.split(":");
            this.parentAttributes.put(couple[0], couple[1]);
            ++n2;
        }
    }

    protected void storeProperties() {
        PreferenceStore store = this.dimensionProperties.getDatasetProperties().getPreferenceStore();
        store.setValue(String.valueOf(this.id) + ".concept", this.concept.getAcronym());
        store.setValue(String.valueOf(this.id) + ".attribute", this.attribute.getAcronym());
        store.setValue(String.valueOf(this.id) + ".alternate", this.alternate != null ? this.alternate.getAcronym() : "");
        StringBuffer bufParents = new StringBuffer();
        if (this.parentAttributes.size() > 0) {
            for (String parent_concept : this.parentAttributes.keySet()) {
                bufParents.append(parent_concept);
                bufParents.append(':');
                bufParents.append(this.parentAttributes.get(parent_concept));
                bufParents.append('#');
            }
            bufParents.trimToSize();
            store.setValue(String.valueOf(this.id) + ".parents", bufParents.substring(0, bufParents.length() - 1));
        }
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

