/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.StatusLineContributionItem;
import org.fao.fi.fishstat.gui.core.session.GuiSession;

public class StatusBarController {
    public static final String RECORD_NUMBER = "RECORD_NUMBER";
    public static final String TOTAL_RECORDS = "TOTAL_RECORDS";
    public static final String TIME_SERIES_UNIT = "TIME_SERIES_UNIT";
    private IStatusLineManager statusLineManager = null;
    private StatusLineContributionItem recordNumberContributionItem = new StatusLineContributionItem("RECORD_NUMBER", true, 20);
    private StatusLineContributionItem totalRecordsContributionItem = new StatusLineContributionItem("TOTAL_RECORDS", true, 30);
    private StatusLineContributionItem timeSeriesUnitContributionItem = new StatusLineContributionItem("TIME_SERIES_UNIT", true, 40);

    public void setRecordNumber(int number) {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(() -> this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + (number + 1) + " " + Activator.getLocalString("label.of.first.lower")));
        }
    }

    public void cleanRecordNumber() {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(() -> this.recordNumberContributionItem.setText(""));
        }
    }

    public void setTotalRecords(GuiSession session) {
        if (this.totalRecordsContributionItem == null) {
            return;
        }
        int totalObservations = 0;
        if (session.getLastResult() != null) {
            try {
                totalObservations = session.getLastResult().getObservations().size();
            }
            catch (Exception exception) {}
        }
        AggregationWrapper aggreg = session.getAggregationRequest();
        FilterWrapper filter = session.getFilterRequest();
        if (aggreg == null && filter != null && !filter.hasFilterSet()) {
            String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.records");
            Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
            return;
        }
        if (aggreg != null && filter != null && !filter.hasFilterSet()) {
            String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.aggregated.records");
            Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
            return;
        }
        String text = String.valueOf(Integer.toString(totalObservations)) + " " + Activator.getLocalString("label.filtered.records");
        Display.getDefault().asyncExec(() -> this.totalRecordsContributionItem.setText(text));
    }

    public void setRecordNumberOf(int recno, int of) {
        if (this.recordNumberContributionItem != null && this.totalRecordsContributionItem != null) {
            Display.getDefault().asyncExec(() -> {
                this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + recno + " " + Activator.getLocalString("label.of.first.lower"));
                this.totalRecordsContributionItem.setText(String.valueOf(of) + " " + Activator.getLocalString("label.filtered.records"));
            });
        }
    }

    public void setUnit(String[] unit) {
        if (this.timeSeriesUnitContributionItem != null && unit != null && unit.length > 0) {
            Display.getDefault().asyncExec(() -> {
                if (unit[0] == null || unit[1] == null) {
                    this.timeSeriesUnitContributionItem.setText("");
                    this.timeSeriesUnitContributionItem.setToolTipText("");
                } else {
                    Map<String, String> display = this.getMeasureDisplay(unit);
                    this.timeSeriesUnitContributionItem.setText(String.valueOf(Activator.getLocalString("label.unit.column")) + " " + display.get("text"));
                    this.timeSeriesUnitContributionItem.setToolTipText(display.get("tooltip"));
                }
            });
        }
    }

    private Map<String, String> getMeasureDisplay(String[] unit) {
        String[] unitCodes;
        String measureCode = unit[0];
        Concept concept = ReferenceServiceFactory.getService().getConcept("MEASURE");
        StringBuilder unitText = new StringBuilder();
        StringBuilder unitTooltip = new StringBuilder();
        String[] stringArray = unitCodes = measureCode.split(",");
        int n = unitCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String oneCode = stringArray[n2];
            ReferenceObject refObject = concept.getObject(concept.getAttribute("CODE"), (Object)this.mapLegacyUnits(oneCode, unit[1]));
            if (refObject == null) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("text", "");
                result.put("tooltip", "");
                return result;
            }
            if (unitText.length() > 0) {
                unitText.append(", ");
                unitTooltip.append(", ");
            }
            Object shortNameAtt = refObject.getAttribute("SHORT_NAME");
            Object nameAtt = refObject.getAttribute("NAME");
            if (shortNameAtt != null) {
                unitText.append(shortNameAtt.toString());
            } else {
                unitText.append(((MultilingualString)nameAtt).getValue(CoreCommons.LOCALE2));
            }
            unitTooltip.append(((MultilingualString)nameAtt).getValue(CoreCommons.LOCALE2));
            ++n2;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("text", unitText.toString());
        result.put("tooltip", unitTooltip.toString());
        return result;
    }

    private String mapLegacyUnits(String unit, String multiplier) {
        if (unit.equals("USD") && multiplier != null && multiplier.equals("3")) {
            return "V_USD_1000";
        }
        if (unit.equals("no") && multiplier != null && multiplier.equals("3")) {
            return "Q_no_1000";
        }
        if (unit.equals("t") && multiplier != null && multiplier.equals("0")) {
            return "Q_t_1";
        }
        if (unit.equals("no")) {
            return "Q_no_1";
        }
        if (unit.equals("tlw")) {
            return "Q_tlw";
        }
        if (unit.equals("tpw")) {
            return "Q_tpw";
        }
        return unit;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    protected void setStatusLineManager(IStatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void activateContributions() {
        if (this.statusLineManager.find(RECORD_NUMBER) == null) {
            this.statusLineManager.add((IContributionItem)this.recordNumberContributionItem);
        }
        if (this.statusLineManager.find(TOTAL_RECORDS) == null) {
            this.statusLineManager.insertAfter(RECORD_NUMBER, (IContributionItem)this.totalRecordsContributionItem);
        }
        if (this.statusLineManager.find(TIME_SERIES_UNIT) == null) {
            this.statusLineManager.insertAfter(TOTAL_RECORDS, (IContributionItem)this.timeSeriesUnitContributionItem);
        }
        this.statusLineManager.update(false);
    }

    public void deactivateAllContribtions() {
        this.statusLineManager.removeAll();
        this.statusLineManager.update(false);
    }
}

