/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.topothers;

import java.beans.Beans;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.combos.MeasureDimensionComboViewer;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.topothers.MeasuresComboViewer;

public class TopOtherComposite {
    private TopCriteriaWrapper request = null;
    private Section section;
    private Label lblByField;
    private MeasuresComboViewer cmbPeriods;
    private Button rbtAllRecords;
    private Button rbtTop;
    private Button rbtComprising;
    private Button rbtValuesAndGreater;
    private Label lblRecords;
    private Label lblPercentOfTotal;
    private Label lblAndGreater;
    private Text txtNumberOfTopRecords;
    private Text txtPercentOfTotal;
    private Text txtValuesAndGreater;
    private Label lblByMeasure;
    private MeasureDimensionComboViewer cmbMeasure;
    private Dimension observedMeasureDimension;

    public TopOtherComposite(Composite parent, TopCriteriaWrapper r) {
        this.request = r;
        this.initGUI(parent);
        this.valorize();
        if (r != null) {
            this.syncroPanel(r);
        }
    }

    private void initGUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getCurrent());
        this.section = toolkit.createSection(parent, 256);
        Composite composite = toolkit.createComposite((Composite)this.section, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.section.setClient((Control)composite);
        this.lblByField = toolkit.createLabel(composite, Activator.getLocalString("label.topother.byfield.column"), 0);
        this.lblByField.setLayoutData((Object)new GridData(128, 16384, false, false, 1, 1));
        if (Beans.isDesignTime()) {
            this.observedMeasureDimension = null;
            this.cmbPeriods = new MeasuresComboViewer(composite, null);
        } else {
            this.observedMeasureDimension = this.request.getSession().getTimeseries().getDataset().getObservedMeasureDimension();
            this.cmbPeriods = new MeasuresComboViewer(composite, (GuiSession)this.request.getSession());
        }
        if (this.hasObservedMeasureDimension()) {
            this.lblByMeasure = new Label(composite, 0);
            this.lblByMeasure.setLayoutData((Object)new GridData(128, 16384, false, false, 1, 1));
            toolkit.adapt((Control)this.lblByMeasure, true, true);
            this.lblByMeasure.setText(Activator.getLocalString("label.topother.byfield.measure"));
            if (!Beans.isDesignTime()) {
                this.cmbMeasure = new MeasureDimensionComboViewer(composite, this.request.getSession().getTimeseries(), Activator.getLanguage());
                this.lblByMeasure.setVisible(true);
            }
        }
        Composite composite1 = toolkit.createCompositeSeparator(composite);
        GridData gridData3 = new GridData(4, 4, false, false, 3, 1);
        gridData3.heightHint = 5;
        composite1.setLayoutData((Object)gridData3);
        this.rbtAllRecords = new Button(composite, 16);
        this.rbtAllRecords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtAllRecords);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(false);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(false);
                }
            }
        });
        this.rbtAllRecords.setBackground(ComponentsCommons.getColor((int)25));
        GridData gridData2 = new GridData(16384, 4, false, true, 1, 1);
        this.rbtAllRecords.setLayoutData((Object)gridData2);
        new Label(composite, 0);
        new Label(composite, 0);
        this.rbtTop = new Button(composite, 16);
        this.rbtTop.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtTop);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtTop.setBackground(ComponentsCommons.getColor((int)25));
        this.txtNumberOfTopRecords = new Text(composite, 2048);
        this.txtNumberOfTopRecords.setTextLimit(6);
        this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        GridData gdTxtNumberOfTopRecords = new GridData(4, 4, false, false, 1, 1);
        this.txtNumberOfTopRecords.setLayoutData((Object)gdTxtNumberOfTopRecords);
        this.lblRecords = new Label(composite, 0);
        this.lblRecords.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.rbtComprising = new Button(composite, 16);
        this.rbtComprising.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtComprising.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtComprising);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtComprising.setBackground(ComponentsCommons.getColor((int)25));
        this.txtPercentOfTotal = new Text(composite, 2048);
        this.txtPercentOfTotal.setTextLimit(2);
        this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        this.txtPercentOfTotal.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblPercentOfTotal = new Label(composite, 0);
        this.lblPercentOfTotal.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.rbtValuesAndGreater = new Button(composite, 16);
        this.rbtValuesAndGreater.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtValuesAndGreater.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtValuesAndGreater);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)25));
        this.txtValuesAndGreater = new Text(composite, 2048);
        this.txtValuesAndGreater.setTextLimit(8);
        this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        this.txtValuesAndGreater.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblAndGreater = toolkit.createLabel(composite, "", 0);
        this.lblAndGreater.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
    }

    private void selectOption(Button button) {
        if (button.equals(this.rbtAllRecords)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtTop)) {
            this.txtNumberOfTopRecords.setVisible(true);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtComprising)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(true);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtValuesAndGreater)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(true);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
        }
    }

    private void valorize() {
        if (!Beans.isDesignTime()) {
            this.section.setText(String.valueOf(Activator.getLocalString("label.topother.dataset")) + " " + CoreUtils.getCurrentLang((MultilingualString)this.request.getSession().getTimeseries().getDataset().getName(), (String)Activator.getLanguage()));
        } else {
            this.section.setText("");
        }
        if (this.hasObservedMeasureDimension()) {
            this.lblByField.setText(Activator.getLocalString("label.topother.byfield"));
            this.lblByMeasure.setText(Activator.getLocalString("label.topother.measure"));
        }
        this.rbtAllRecords.setText(Activator.getLocalString("label.topother.allrecords"));
        this.rbtTop.setText(Activator.getLocalString("label.topother.recstop.top"));
        this.lblRecords.setText(Activator.getLocalString("label.topother.recstop.records"));
        this.rbtComprising.setText(Activator.getLocalString("label.topother.recscomprising.comprising"));
        this.lblPercentOfTotal.setText(Activator.getLocalString("label.topother.recscomprising.percent"));
        this.rbtValuesAndGreater.setText(Activator.getLocalString("label.topother.recsvalue.values"));
        this.lblAndGreater.setText(Activator.getLocalString("label.topother.recsvalue.andgreater"));
    }

    public boolean hasObservedMeasureDimension() {
        return this.observedMeasureDimension != null;
    }

    public boolean applyData(TopCriteriaWrapper wrapper) {
        Object selection = ((StructuredSelection)this.cmbPeriods.getSelection()).getFirstElement();
        Object type = this.rbtTop.getSelection() ? TopCriteria.CriteriaType.TOP_RECORDS_NUMBER : (this.rbtComprising.getSelection() ? TopCriteria.CriteriaType.TOP_RECORDS_PERCENT : (this.rbtValuesAndGreater.getSelection() ? TopCriteria.CriteriaType.TOP_RECORDS_VALUE : null));
        int criteriaValue = 0;
        if (type != null && (criteriaValue = this.isInputValid((TopCriteria.CriteriaType)type)) == 0) {
            return false;
        }
        if (selection instanceof CalculatedMeasureDefinition) {
            wrapper.setCalcmd_name(((CalculatedMeasureDefinition)selection).getName());
        } else {
            wrapper.setPeriod_id(((ObservationPeriod)selection).toString());
        }
        if (this.hasObservedMeasureDimension()) {
            wrapper.setMeasure((ReferenceObject)((StructuredSelection)this.cmbMeasure.getSelection()).getFirstElement());
        }
        wrapper.setCriteriaType(type);
        wrapper.setValue(criteriaValue);
        return true;
    }

    private int isInputValid(TopCriteria.CriteriaType type) {
        String userInput = null;
        switch (type) {
            case TOP_RECORDS_NUMBER: {
                userInput = this.txtNumberOfTopRecords.getText();
                break;
            }
            case TOP_RECORDS_PERCENT: {
                userInput = this.txtPercentOfTotal.getText();
                break;
            }
            case TOP_RECORDS_VALUE: {
                userInput = this.txtValuesAndGreater.getText();
            }
        }
        if (type == null || userInput == null || userInput.isEmpty()) {
            MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)Activator.getLocalString("label.topother.inputerr.missinginput"));
            return 0;
        }
        Pattern pattern = Pattern.compile("^([0-9]+)$");
        Matcher m = pattern.matcher(userInput);
        if (!m.find()) {
            MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)MessageFormat.format(Activator.getLocalString("label.topother.inputerr.notnumeric"), userInput));
            return 0;
        }
        int value = 0;
        try {
            value = Integer.parseInt(userInput);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)MessageFormat.format(Activator.getLocalString("label.topother.inputerr.notnumeric"), userInput));
            return 0;
        }
        switch (type) {
            case TOP_RECORDS_NUMBER: {
                if (value >= 1) break;
                MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)MessageFormat.format(Activator.getLocalString("label.topother.inputerr.recszero"), userInput));
                return 0;
            }
            case TOP_RECORDS_PERCENT: {
                if (value >= 1) break;
                MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)MessageFormat.format(Activator.getLocalString("label.topother.inputerr.percentzero"), userInput));
                return 0;
            }
            case TOP_RECORDS_VALUE: {
                if (value >= 1) break;
                MessageDialog.openInformation(null, (String)Activator.getLocalString("label.topother.inputerr.message"), (String)MessageFormat.format(Activator.getLocalString("label.topother.inputerr.valuezero"), userInput));
                return 0;
            }
        }
        return value;
    }

    private void syncroPanel(TopCriteriaWrapper tw) {
        if (tw.getType() == 1) {
            if (tw.hasPeriod_id()) {
                this.cmbPeriods.setSelection((ISelection)new StructuredSelection((Object)ObservationPeriod.valueOf((String)tw.getPeriod_id())));
            }
        } else if (tw.hasCalcmd_name()) {
            this.cmbPeriods.setSelection((ISelection)new StructuredSelection((Object)tw.getSession().getLastResult().getCalculatedMeasureDefinition(tw.getCalcColName())));
        }
        if (tw.hasMeasure()) {
            this.cmbMeasure.setSelection((ISelection)new StructuredSelection((Object)tw.getMeasure()));
        }
        if (tw.hasCriteriaType()) {
            if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_NUMBER)) {
                this.rbtTop.setSelection(true);
                this.selectOption(this.rbtTop);
                this.txtNumberOfTopRecords.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            } else if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_PERCENT)) {
                this.rbtComprising.setSelection(true);
                this.selectOption(this.rbtComprising);
                this.txtPercentOfTotal.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            } else if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_VALUE)) {
                this.rbtValuesAndGreater.setSelection(true);
                this.selectOption(this.rbtValuesAndGreater);
                this.txtValuesAndGreater.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        } else {
            this.rbtAllRecords.setSelection(true);
            this.selectOption(this.rbtAllRecords);
            this.cmbPeriods.getComboViewer().getCombo().setEnabled(false);
            if (this.hasObservedMeasureDimension()) {
                this.cmbMeasure.getComboViewer().getCombo().setEnabled(false);
            }
        }
    }
}

