/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;

public class ObservationTableLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    TimeSeriesProperties properties;
    private final MeasureDisplayer displayer = new MeasureDisplayer();

    public ObservationTableLabelProvider(TimeSeriesProperties properties) {
        this.properties = properties;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ObservationSeries && columnIndex > 0 && columnIndex <= this.properties.getPeriodsSize()) {
            ObservationSeries obs = (ObservationSeries)element;
            return this.displayer.getMeasureLabel(obs.getMeasure(this.properties.getPeriod(columnIndex - 1)), true);
        }
        return "";
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof ObservationSeries && columnIndex > 0 && columnIndex <= this.properties.getPeriodsSize()) {
            return this.displayer.getForeground(((ObservationSeries)element).getMeasure(this.properties.getPeriod(columnIndex - 1)));
        }
        return null;
    }
}

