/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TimeResolution
implements Serializable {
    private static final long serialVersionUID = -1166387247256084819L;
    private static final String YEAR_RESOLUTION = "Y";
    private static final String QUARTER_RESOLUTION = "Q";
    private static final String MONTH_RESOLUTION = "M";
    private static final String CUSTOM_RESOLUTION = "C";
    public static final TimeResolution YEAR = new TimeResolution("Y");
    public static final TimeResolution QUARTER = new TimeResolution("Q");
    public static final TimeResolution MONTH = new TimeResolution("M");
    public static final TimeResolution CUSTOM = new TimeResolution("C");
    private static final List<String> RESOLUTION_KEYS = Collections.unmodifiableList(Arrays.asList("Y", "Q", "M", "C"));
    public static final Set<TimeResolution> RESOLUTIONS = Collections.unmodifiableSet(new LinkedHashSet<TimeResolution>(Arrays.asList(YEAR, MONTH, QUARTER, CUSTOM)));
    private String resolution;

    private TimeResolution(String resolution) {
        this.resolution = resolution;
    }

    private String getResolution() {
        return this.resolution;
    }

    public static TimeResolution valueOf(String resolution) {
        if (RESOLUTION_KEYS.contains(resolution)) {
            return new TimeResolution(resolution);
        }
        throw new IllegalArgumentException("Invalid resolution: " + resolution);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resolution == null ? 0 : this.resolution.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeResolution)) {
            return false;
        }
        TimeResolution other = (TimeResolution)obj;
        return !(this.resolution == null ? other.resolution != null : !this.resolution.equals(other.resolution));
    }

    public String toString() {
        return this.getResolution();
    }
}

