/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.PeriodsFunction;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;

public class AggregatePeriod
extends FunctionBase
implements PeriodsFunction {
    public AggregatePeriod() {
    }

    public AggregatePeriod(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(Map<ObservationPeriod, Double> series, Map<Parameter, String> parameters) {
        Double result = 0.0;
        String parameter = parameters.get(this.getParameter(Parameters.AGGREGATED_PERIOD.name()));
        String year = ObservationPeriod.valueOf(parameter).getYear();
        for (Map.Entry<ObservationPeriod, Double> value : series.entrySet()) {
            if (!value.getKey().getYear().equals(year)) continue;
            result = result + value.getValue();
        }
        return result;
    }

    @Override
    public String[] getParameterEnumeratedValues(Parameter parameter) {
        return null;
    }

    @Override
    public boolean isValidParameterValue(Parameter parameter, String value) {
        if (parameter == null) {
            return true;
        }
        if (Parameters.AGGREGATED_PERIOD.name().equalsIgnoreCase(parameter.getAcronym())) {
            try {
                return ObservationPeriod.isValid(value);
            }
            catch (Exception exception) {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a valid observation period parameter: " + parameter);
    }

    public static enum Parameters {
        AGGREGATED_PERIOD;

    }
}

