/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.model.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;

public class ParameterWrapper
extends Observable
implements Comparable<ParameterWrapper> {
    private Parameter parameter;
    private String value;
    private ArrayList<String> enumeratedValues;
    private boolean valid;

    public ParameterWrapper(Parameter parameter, String value) {
        this.parameter = parameter;
        if (parameter.getEnumeratedValues() != null) {
            this.enumeratedValues = new ArrayList<String>(Arrays.asList(parameter.getEnumeratedValues()));
        }
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.chkValue();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public List<String> getEnumeratedValues() {
        return this.enumeratedValues;
    }

    public boolean hasEnumeratedValues() {
        return this.enumeratedValues != null;
    }

    private void chkValue() {
        this.valid = this.parameter.isValid(this.value);
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        return this.parameter.getAcronym().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterWrapper)) {
            return false;
        }
        return this == (ParameterWrapper)obj;
    }

    @Override
    public int compareTo(ParameterWrapper o) {
        return this.parameter.getAcronym().compareTo(o.parameter.getAcronym());
    }
}

