/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.gui.viewers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class ConceptViewersFactory {
    private static ConceptViewersFactory factory;

    private ConceptViewersFactory() {
    }

    public static ConceptViewersFactory getFactory() {
        if (factory == null) {
            factory = new ConceptViewersFactory();
        }
        return factory;
    }

    public ComboViewer createComboViewer(Composite parent, String lang) {
        ComboViewer result = new ComboViewer(parent, 0);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    public ListViewer createListViewer(Composite parent, String lang) {
        ListViewer result = new ListViewer(parent, 0);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private class ConceptsContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Concept> userdefinedConcepts = new ArrayList<Concept>();
            for (Concept concept : ReferenceServiceFactory.getService().getConcepts()) {
                if (this.isInternalConcept(concept.getAcronym())) continue;
                userdefinedConcepts.add(concept);
            }
            return userdefinedConcepts.toArray();
        }

        private boolean isInternalConcept(String acronym) {
            return acronym.startsWith("FST_") || acronym.equals("PREDEFINED") || acronym.equals("MEASURE") || acronym.equals("MONTH") || acronym.equals("QUARTER") || acronym.equals("LANGUAGE") || acronym.equals("CUSTOM_GROUP");
        }
    }

    private class ConceptsLabelProvider
    extends LabelProvider {
        private String lang = null;

        public ConceptsLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)this.lang);
            }
            return super.getText(element);
        }
    }

    private class ConceptsSorter
    extends ViewerComparator {
        private String lang;

        public ConceptsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            try {
                if (c1 instanceof Concept && c2 instanceof Concept) {
                    return CoreUtils.getCurrentLangName((Object)c1, (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)c2, (String)this.lang));
                }
            }
            catch (Exception e) {
                ComponentsActivator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "ConceptViewersFactory.compare", (Throwable)e));
            }
            return 0;
        }
    }
}

