/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import java.beans.Beans;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.components.providers.MeasureDimensionProvidersFactory;

public class MeasureDimensionComboViewer {
    private ComboViewer comboViewer;

    public MeasureDimensionComboViewer(Composite parent, Timeseries timeseries, String lang) {
        this.comboViewer = new ComboViewer(parent, 0);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (!Beans.isDesignTime()) {
            this.comboViewer.setContentProvider((IContentProvider)MeasureDimensionProvidersFactory.getContentProvider());
            this.comboViewer.setLabelProvider((IBaseLabelProvider)MeasureDimensionProvidersFactory.getLabelProvider(lang));
            this.comboViewer.setComparator((ViewerComparator)new MeasureDimensionSorter(lang));
            this.comboViewer.setInput((Object)timeseries);
            this.comboViewer.getCombo().select(0);
        }
    }

    public ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    public ISelection getSelection() {
        return this.comboViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.comboViewer.setSelection(selection);
    }

    private class MeasureDimensionSorter
    extends ViewerComparator {
        private String compLang;

        public MeasureDimensionSorter(String lang) {
            this.compLang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ReferenceObject && e2 instanceof ReferenceObject) {
                ReferenceObject r1 = (ReferenceObject)e1;
                ReferenceObject r2 = (ReferenceObject)e2;
                Object c1 = r1.getAttribute("CODE");
                Object c2 = r2.getAttribute("CODE");
                if (c1 == null) {
                    return 1;
                }
                if (c2 == null) {
                    return -1;
                }
                if (c1 instanceof String && c2 instanceof String) {
                    if (((String)c1).startsWith("Q_t")) {
                        return -1;
                    }
                    if (((String)c2).startsWith("Q_t")) {
                        return 1;
                    }
                    return this.sortAttributeName(r1.getAttribute("NAME"), r2.getAttribute("NAME"));
                }
                if (c1 instanceof Long && c2 instanceof Long) {
                    return ((Long)c1).compareTo((Long)c2);
                }
            }
            return super.compare(viewer, (Object)e1.toString(), (Object)e2.toString());
        }

        private int sortAttributeName(Object a1, Object a2) {
            if (a1 instanceof MultilingualString && a2 instanceof MultilingualString) {
                MultilingualString m1 = (MultilingualString)a1;
                MultilingualString m2 = (MultilingualString)a2;
                String n1 = m1.getValue(this.compLang);
                String n2 = m2.getValue(this.compLang);
                if (n1 == null || n2 == null) {
                    return 0;
                }
                return n1.compareTo(n2);
            }
            return 0;
        }
    }
}

