/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.status;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.FAOMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;

public class MeasureStatusCalculatorFAO
implements MeasureStatusCalculator {
    private Map<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>> statusMap = new HashMap<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>>();

    public MeasureStatusCalculatorFAO() {
        this.reset();
    }

    @Override
    public void reset() {
        this.statusMap.clear();
    }

    @Override
    public void calculate(ObservationSeries aggregated, ObservationSeries series) throws Exception {
        Map<ObservationPeriod, Measure> series_measures = series.getMeasures();
        Map<ObservationPeriod, Measure> aggregated_measures = aggregated.getMeasures();
        MultiReferenceObject multikey = aggregated.getKeys();
        Map<ObservationPeriod, DoubleValue> status_row = this.statusMap.get(multikey);
        if (status_row == null) {
            status_row = new HashMap<ObservationPeriod, DoubleValue>();
            this.statusMap.put(multikey, status_row);
        }
        for (ObservationPeriod period : series.getTimeseries().getObservationPeriods()) {
            Measure observation_measure = series_measures.get(period);
            Measure aggregated_measure = aggregated_measures.get(period);
            DoubleValue value = status_row.computeIfAbsent(period, k -> new DoubleValue());
            this.aggregate(aggregated_measure, observation_measure, value);
        }
    }

    private void aggregate(Measure aggregated, Measure measure, DoubleValue value) throws Exception {
        if (aggregated == null || measure == null) {
            throw new IllegalArgumentException("Measure can not be null");
        }
        MeasureStatus aggregated_symbol = aggregated.getStatus();
        MeasureStatus measure_symbol = measure.getStatus();
        if (aggregated_symbol == null) {
            aggregated_symbol = FAOMeasureStatus.OFFICIAL;
        }
        if (measure_symbol == null) {
            measure_symbol = FAOMeasureStatus.OFFICIAL;
        }
        if (aggregated.getValue() == 0.0 && measure.getValue() == 0.0) {
            if (aggregated_symbol.equals(FAOMeasureStatus.NEGLIBILE) || measure_symbol.equals(FAOMeasureStatus.NEGLIBILE)) {
                aggregated.setStatus(FAOMeasureStatus.NEGLIBILE);
            } else if (aggregated_symbol.equals(FAOMeasureStatus.MISSING) || measure_symbol.equals(FAOMeasureStatus.MISSING)) {
                aggregated.setStatus(FAOMeasureStatus.MISSING);
            } else if (aggregated_symbol.equals(FAOMeasureStatus.ZERO) || measure_symbol.equals(FAOMeasureStatus.ZERO)) {
                aggregated.setStatus(FAOMeasureStatus.ZERO);
            } else if (aggregated_symbol.equals(FAOMeasureStatus.NOTCOLLECTED) || measure_symbol.equals(FAOMeasureStatus.NOTCOLLECTED)) {
                aggregated.setStatus(FAOMeasureStatus.NOTCOLLECTED);
            } else {
                aggregated.setStatus(FAOMeasureStatus.OFFICIAL);
            }
        } else if (measure.getValue() != 0.0) {
            value.addValue(measure.getValue(), measure_symbol);
            aggregated.setStatus(value.getStatus());
        }
    }

    final class DoubleValue {
        double total = 0.0;
        double official = 0.0;
        boolean isAllSameFlags = true;
        MeasureStatus statusFlag = null;

        DoubleValue() {
        }

        public MeasureStatus getStatus() {
            double twothird = this.total / 3.0 * 2.0;
            if (this.official >= twothird) {
                return FAOMeasureStatus.OFFICIAL;
            }
            if (this.statusFlag != null && this.isAllSameFlags && !this.statusFlag.equals(FAOMeasureStatus.IMPUTED)) {
                return this.statusFlag;
            }
            return FAOMeasureStatus.ESTIMATE;
        }

        public void addValue(double value, MeasureStatus measure_symbol) {
            this.total += value;
            if (measure_symbol.equals(FAOMeasureStatus.OFFICIAL)) {
                this.official += value;
            }
            if (this.statusFlag == null) {
                this.statusFlag = measure_symbol;
            } else if (!measure_symbol.equals(this.statusFlag)) {
                this.isAllSameFlags = false;
            }
        }
    }
}

