/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.display;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class MeasureDisplayer
implements IGuiPreferencesConstants,
IPropertyChangeListener {
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
    private Font fontbold;
    private DecimalFormat decimalFormatObs;
    private DecimalFormat decimalFormatClc;

    public MeasureDisplayer() {
        this.ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fontbold = ComponentsCommons.getFont((String)"", (int)8, (int)1);
        this.decimalFormatObs = this.calculateDecimalFormatStt();
        this.decimalFormatClc = this.calculateDecimalFormatClc();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().contains("display.numbers")) {
            this.decimalFormatObs = this.calculateDecimalFormatStt();
            this.decimalFormatClc = this.calculateDecimalFormatClc();
        }
    }

    public Color getForeground(Measure m) {
        if (m != null && m.getStatus() != null) {
            if (m.getStatus().toString().equals("B") && ApplicationPreferences.getDataDisplayHilited(1)) {
                return ApplicationPreferences.getDataDisplayColors(1);
            }
            if (m.getStatus().toString().equals("E") && ApplicationPreferences.getDataDisplayHilited(2)) {
                return ApplicationPreferences.getDataDisplayColors(2);
            }
            if (m.getStatus().toString().equals("F") && ApplicationPreferences.getDataDisplayHilited(3)) {
                return ApplicationPreferences.getDataDisplayColors(3);
            }
            if (m.getStatus().toString().equals("G") && ApplicationPreferences.getDataDisplayHilited(4)) {
                return ApplicationPreferences.getDataDisplayColors(4);
            }
            if (m.getStatus().toString().equals("I") && ApplicationPreferences.getDataDisplayHilited(5)) {
                return ApplicationPreferences.getDataDisplayColors(5);
            }
            if (m.getStatus().toString().equals("L") && ApplicationPreferences.getDataDisplayHilited(6)) {
                return ApplicationPreferences.getDataDisplayColors(6);
            }
            if (m.getStatus().toString().equals("M") && ApplicationPreferences.getDataDisplayHilited(7)) {
                return ApplicationPreferences.getDataDisplayColors(7);
            }
            if (m.getStatus().toString().equals("N") && ApplicationPreferences.getDataDisplayHilited(8)) {
                return ApplicationPreferences.getDataDisplayColors(8);
            }
            if (m.getStatus().toString().equals("O") || m.getStatus().toString().equals("...") && ApplicationPreferences.getDataDisplayHilited(9)) {
                return ApplicationPreferences.getDataDisplayColors(9);
            }
            if (m.getStatus().toString().equals("P") && ApplicationPreferences.getDataDisplayHilited(10)) {
                return ApplicationPreferences.getDataDisplayColors(10);
            }
            if (m.getStatus().toString().equals("Q") && ApplicationPreferences.getDataDisplayHilited(11)) {
                return ApplicationPreferences.getDataDisplayColors(11);
            }
            if (m.getStatus().toString().equals("S") && ApplicationPreferences.getDataDisplayHilited(12)) {
                return ApplicationPreferences.getDataDisplayColors(12);
            }
            if (m.getStatus().toString().equals("U") && ApplicationPreferences.getDataDisplayHilited(13)) {
                return ApplicationPreferences.getDataDisplayColors(13);
            }
            if (m.getStatus().toString().equals("V") && ApplicationPreferences.getDataDisplayHilited(14)) {
                return ApplicationPreferences.getDataDisplayColors(14);
            }
            if (m.getStatus().toString().equals("X") && ApplicationPreferences.getDataDisplayHilited(15)) {
                return ApplicationPreferences.getDataDisplayColors(15);
            }
        }
        return null;
    }

    private DecimalFormat calculateDecimalFormatStt() {
        StringBuffer pattern = new StringBuffer(20);
        int i = 0;
        while (i < this.ps.getInt("display.numbers.before.decimals.obsrv.measures")) {
            pattern.append('0');
            ++i;
        }
        pattern.append('.');
        char patchar = this.ps.getInt("display.numbers.modes.after.decimals.obsrv.measures") == 0 ? (char)'#' : '0';
        int i2 = 0;
        while (i2 < this.ps.getInt("display.numbers.after.decimals.obsrv.measures")) {
            pattern.append(patchar);
            ++i2;
        }
        if (this.ps.getBoolean("display.numbers.modes.expo")) {
            pattern.append("E00");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.ps.getBoolean("display.numbers.modes.comma") ? (char)',' : '.');
        return new DecimalFormat(pattern.toString(), symbols);
    }

    private DecimalFormat calculateDecimalFormatClc() {
        StringBuffer pattern = new StringBuffer(20);
        int i = 0;
        while (i < this.ps.getInt("display.numbers.before.decimals.calc.measures")) {
            pattern.append('0');
            ++i;
        }
        pattern.append('.');
        char patchar = this.ps.getInt("display.numbers.modes.after.decimals.calc.measures") == 0 ? (char)'#' : '0';
        int i2 = 0;
        while (i2 < this.ps.getInt("display.numbers.after.decimals.calc.measures")) {
            pattern.append(patchar);
            ++i2;
        }
        if (this.ps.getBoolean("display.numbers.modes.expo")) {
            pattern.append("E00");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.ps.getBoolean("display.numbers.modes.comma") ? (char)',' : '.');
        return new DecimalFormat(pattern.toString(), symbols);
    }

    public Font getFont(Measure m) {
        if (m != null && m.getStatus() != null && m.getStatus().toString().equals("F") && ApplicationPreferences.getDataDisplayHilited(2)) {
            return this.fontbold;
        }
        return null;
    }

    public Font getFontbold() {
        return this.fontbold;
    }

    public String getMeasureLabel(Measure m, boolean observed) {
        if (m != null) {
            DecimalFormat decimalFormat = observed ? this.decimalFormatObs : this.decimalFormatClc;
            String textualValue = decimalFormat.format(m.getValue());
            if (textualValue.endsWith(".")) {
                textualValue = textualValue.substring(0, textualValue.length() - 1);
            }
            return String.valueOf(textualValue) + "  " + this.getStatusLabel(m);
        }
        return "error: null value";
    }

    public String getStatusLabel(Measure m) {
        if (m.getStatus() != null) {
            String status = m.getStatus().toString();
            if (status.equals("B") || status.equals("E") || status.equals("F") || status.equals("G") || status.equals("I") || status.equals("L") || status.equals("N") || status.equals("M") || status.equals("P") || status.equals("Q") || status.equals("S") || status.equals("U") || status.equals("V") || status.equals("X") || status.equals("")) {
                return status;
            }
            if (status.equals("A") || status.equals("[blank]") || status.equals("")) {
                return LABEL_OFFICIAL[this.getIntPerference("display.value.official", LABEL_OFFICIAL.length)];
            }
            if (status.equals("O") || status.equals("...")) {
                return LABEL_ZERO[this.getIntPerference("display.value.zero", LABEL_ZERO.length)];
            }
        }
        return "";
    }

    private int getIntPerference(String preferenceName, int maxValue) {
        int value = this.ps.getInt(preferenceName);
        if (value < 0 || value >= maxValue) {
            return this.ps.getDefaultInt(preferenceName);
        }
        return value;
    }

    public String getOnlyValue(Measure m, boolean observed) {
        if (m != null) {
            DecimalFormat decimalFormat = observed ? this.decimalFormatObs : this.decimalFormatClc;
            String textValue = decimalFormat.format(m.getValue());
            if (textValue.endsWith(".")) {
                textValue = textValue.substring(0, textValue.length() - 1);
            }
            return textValue;
        }
        return "error: null value";
    }
}

