/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;

public class YearDateComposite
extends Composite {
    private final MeasureDisplayer displayer = new MeasureDisplayer();
    private Text quantityText;

    public YearDateComposite(Composite parent, String labelYear) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginLeft = 12;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label yearLabel = new Label((Composite)this, 288);
        yearLabel.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)64));
        yearLabel.setFont(ComponentsCommons.getFont((String)"Arial", (int)8, (int)1));
        yearLabel.setAlignment(131072);
        GridData gd_label = new GridData(1, 0x1000000, false, false);
        yearLabel.setLayoutData((Object)gd_label);
        yearLabel.setBackground(Display.getCurrent().getSystemColor(22));
        yearLabel.setText(labelYear);
        this.quantityText = new Text((Composite)this, 133120);
        GridData gd_textQuantity = new GridData(131072, 128, true, false);
        gd_textQuantity.horizontalIndent = 2;
        gd_textQuantity.horizontalAlignment = 4;
        this.quantityText.setLayoutData((Object)gd_textQuantity);
        this.quantityText.setEditable(false);
    }

    public void setMeasure(Measure m) {
        if (m == null) {
            this.quantityText.setText("");
        } else {
            this.quantityText.setText(this.displayer.getMeasureLabel(m, true));
            this.quantityText.setForeground(this.displayer.getForeground(m));
            this.quantityText.setFont(this.displayer.getFont(m));
            this.quantityText.requestLayout();
        }
    }

    protected void checkSubclass() {
    }
}

