/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableAbstractViewer;
import org.fao.fi.fishstat.gui.views.multitable.ObservationTableLabelProvider;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedContentProvider;

public class ObservationTableViewer
extends MultiTableAbstractViewer {
    private TableColumn[] columns;
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
    private final AutoColumnsResizer columnsResizer = new AutoColumnsResizer();

    public ObservationTableViewer(Composite parent, int style, GuiSession session) {
        super(parent, style);
        this.session = session;
        this.table = this.getTable();
        this.initComponent();
    }

    private void initComponent() {
        this.setUseHashlookup(true);
        this.table.getVerticalBar().setVisible(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getHorizontalBar().setVisible(true);
        this.setContentProvider((IContentProvider)new UnifiedContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ObservationTableLabelProvider(this.session.getTimeseriesProperties()));
        this.rebuildTable();
    }

    @Override
    protected void rebuildTable() {
        this.getTable().setVisible(false);
        if (this.columns != null) {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null && !this.columns[i].isDisposed()) {
                    this.columns[i].dispose();
                }
                this.columns[i] = null;
                ++i;
            }
        }
        ObservationPeriod[] periods = new ObservationPeriod[this.session.getTimeseriesProperties().getPeriodsSize() + 1];
        this.columns = new TableColumn[periods.length];
        this.columns[0] = new TableColumn(this.getTable(), 131072);
        this.columns[0].setResizable(false);
        int i = 1;
        while (i < periods.length) {
            periods[i] = this.session.getTimeseriesProperties().getPeriod(i - 1);
            this.columns[i] = new TableColumn(this.getTable(), 131072);
            this.columns[i].setText(this.getColumnHeader(i));
            new MultiTableAbstractViewer.ColumnViewerSorter(this, (ColumnViewer)this, this.columns[i], i - 1){
                List<ObservationPeriod> selectedPeriods;
                ObservationPeriod year;
                {
                    this.selectedPeriods = ObservationTableViewer.this.session.getTimeseriesProperties().getPeriods();
                    this.year = this.selectedPeriods.get(this.idx);
                }

                @Override
                protected int doCompare(Viewer viewer, Object e1, Object e2) {
                    Measure m2;
                    Measure m1;
                    block10: {
                        if (e1 == null && e2 != null) {
                            return -1;
                        }
                        if (e1 != null && e2 == null) {
                            return 1;
                        }
                        if (e1 == null) {
                            return 0;
                        }
                        try {
                            m1 = null;
                            m2 = null;
                            if (e1 instanceof ObservationSeries && e2 instanceof ObservationSeries) {
                                List obsPeriods = ((ObservationSeries)e1).getTimeseries().getObservationPeriods();
                                int idx2 = obsPeriods.indexOf(this.year);
                                m1 = ((ObservationSeries)e1).getMeasure(idx2);
                                m2 = ((ObservationSeries)e2).getMeasure(idx2);
                            }
                            if (((ObservationSeries)e1).getKey(0) == ReferenceObject.OTHERS) {
                                return this.direction;
                            }
                            if (((ObservationSeries)e2).getKey(0) == ReferenceObject.OTHERS) {
                                return -1 * this.direction;
                            }
                            if (m1 != null && m2 != null) break block10;
                            return 0;
                        }
                        catch (TimeseriesServiceException e) {
                            ComponentsCommons.showExceptionWithStack((Throwable)e);
                            return 0;
                        }
                    }
                    double dd1 = m1.getValue();
                    double dd2 = m2.getValue();
                    if (dd1 == dd2) {
                        return m1.getStatus().toString().compareToIgnoreCase(m2.getStatus().toString());
                    }
                    return dd1 < dd2 ? -1 : 1;
                }
            };
            this.columns[i].setAlignment(131072);
            if (this.ps.getBoolean("display.auto.justify.onscroll")) {
                this.columns[i].pack();
            } else {
                this.columns[i].setWidth(this.ps.getInt("display.fixed.columns.width"));
            }
            ++i;
        }
        this.adjournColumnsHeaders(false);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (((Table)e.widget).getSelectionIndex() == -1) {
                    return;
                }
                int[] positions = ((Table)e.widget).getSelectionIndices();
                for (MultiTableAbstractViewer tableViewer : ObservationTableViewer.this.getParallelTables()) {
                    if (tableViewer.getColumnsCount() <= 0) continue;
                    tableViewer.getTable().select(positions);
                }
            }
        });
        this.getTable().setVisible(true);
        this.table.layout();
        ScrollBar scrollbar = this.table.getVerticalBar();
        if (scrollbar != null) {
            if (this.ps.getBoolean("display.auto.justify.onscroll")) {
                scrollbar.addSelectionListener((SelectionListener)this.columnsResizer);
            } else {
                scrollbar.removeSelectionListener((SelectionListener)this.columnsResizer);
            }
        }
    }

    @Override
    protected String getColumnHeader(int column) {
        if (column == 0) {
            return "";
        }
        return "  " + this.session.getTimeseriesProperties().getPeriod(column - 1).getISO8601() + "  ";
    }

    public void invertColumnOrder() {
        int[] order = this.table.getColumnOrder();
        int i = 0;
        while (i < order.length / 2) {
            int temp = order[i];
            order[i] = order[order.length - i - 1];
            order[order.length - i - 1] = temp;
            ++i;
        }
        this.table.setColumnOrder(order);
    }

    @Override
    protected void adjournLastFocusEntity(FocusEntity entity) {
    }

    private class AutoColumnsResizer
    implements SelectionListener {
        private int lastTopIndex = 0;

        private AutoColumnsResizer() {
        }

        public void widgetSelected(SelectionEvent e) {
            int currentTopIndex = ObservationTableViewer.this.table.getTopIndex();
            if (Math.abs(this.lastTopIndex - currentTopIndex) >= ObservationTableViewer.this.table.getVerticalBar().getPageIncrement()) {
                ObservationTableViewer.this.table.setVisible(false);
                TableColumn[] tableColumnArray = ObservationTableViewer.this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                ObservationTableViewer.this.table.setVisible(true);
            }
            this.lastTopIndex = currentTopIndex;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

