/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces.wizard;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.DownloadFile;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;

public class DownloadNewWorkspacePage
extends WizardPage
implements IGuiPreferencesConstants {
    private InstallNewWorkspaceWizard wizard;
    private Composite container;
    private Label lblFileName;
    public static final String ID = "org.fao.fi.fishstat.gui.gui.workspaces.wizard.download";

    public DownloadNewWorkspacePage(InstallNewWorkspaceWizard wizard) {
        super(ID);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        this.wizard = wizard;
        this.setTitle(Activator.getPluginBundle().getString("workspaces.installing.download.title"));
        this.setDescription(Activator.getPluginBundle().getString("workspaces.installing.download.description"));
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FormLayout());
        Label lblURLtext = new Label(this.container, 16384);
        lblURLtext.setText(Activator.getPluginBundle().getString("workspaces.installing.download.from"));
        FormData fdLblURLtext = new FormData();
        fdLblURLtext.top = new FormAttachment(0, 10);
        fdLblURLtext.left = new FormAttachment(0, 5);
        fdLblURLtext.right = new FormAttachment(100, -10);
        lblURLtext.setLayoutData((Object)fdLblURLtext);
        Label lblURLname = new Label(this.container, 16384);
        lblURLname.setText(this.wizard.getAutoUpdateWks().getUrl());
        FormData fdLblURLname = new FormData();
        fdLblURLname.top = new FormAttachment((Control)lblURLtext, 10);
        fdLblURLname.left = new FormAttachment(0, 5);
        fdLblURLname.right = new FormAttachment(100, -10);
        lblURLname.setLayoutData((Object)fdLblURLname);
        Label lblFiletext = new Label(this.container, 16384);
        lblFiletext.setText(Activator.getPluginBundle().getString("workspaces.installing.download.to"));
        FormData fdLblFileText = new FormData();
        fdLblFileText.top = new FormAttachment((Control)lblURLname, 20);
        fdLblFileText.left = new FormAttachment(0, 5);
        fdLblFileText.right = new FormAttachment(100, 5);
        lblFiletext.setLayoutData((Object)fdLblFileText);
        this.lblFileName = new Label(this.container, 16384);
        this.lblFileName.setText(String.valueOf(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder")) + File.separator + this.wizard.getAutoUpdateWks().getUrl().substring(this.wizard.getAutoUpdateWks().getUrl().lastIndexOf(47) + 1));
        FormData fdLblFileName = new FormData();
        fdLblFileName.top = new FormAttachment((Control)lblFiletext, 20);
        fdLblFileName.left = new FormAttachment(0, 5);
        fdLblFileName.right = new FormAttachment(100, -10);
        this.lblFileName.setLayoutData((Object)fdLblFileName);
        this.setControl((Control)this.container);
        File downloadFodler = new File(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder"));
        if (!downloadFodler.exists() || !downloadFodler.isDirectory()) {
            this.setErrorMessage(Activator.getPluginBundle().getString("workspaces.installing.invalidfolder"));
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.title"), (String)(String.valueOf(Activator.getDefault().getPreferenceStore().getString("workspace.download.folder")) + "\n\n" + Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.message")));
            this.setPageComplete(false);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getErrorMessage() == null) {
            DownloadFile dl = new DownloadFile(this.wizard.getAutoUpdateWks().getUrl());
            if (dl.doDownload(null)) {
                this.wizard.setWsFile(this.lblFileName.getText());
                this.setPageComplete(true);
                this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.download.complete"), 1);
            } else {
                this.setMessage(Activator.getPluginBundle().getString("workspaces.installing.download.failed"), 3);
            }
            this.getWizard().getContainer().updateButtons();
            this.container.update();
        }
    }
}

