/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.util.Observable;
import java.util.Set;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.FunctionFactory;
import org.fao.fi.fishstat.gui.components.widgets.IViewerFactory;

public class FunctionsViewerFactory
implements IViewerFactory {
    private String lang;
    private Composite parent = null;
    private int style = 0;
    private TableViewer tableviewer = null;
    private ComboViewer comboviewer = null;

    private FunctionsViewerFactory(Composite parent, int style, String lang) {
        this.lang = lang;
        this.parent = parent;
        this.style = style;
    }

    public static FunctionsViewerFactory instance(Composite parent, int style, String lang) {
        return new FunctionsViewerFactory(parent, style, lang);
    }

    @Override
    public Viewer getViewer(Class<?> viewerclass) {
        TableViewer result = null;
        if (viewerclass.equals(TableViewer.class)) {
            if (this.tableviewer == null) {
                this.tableviewer = new TableViewer(this.parent, this.style);
                this.tableviewer.setContentProvider((IContentProvider)new FunctionsContentProvider());
                this.tableviewer.setLabelProvider((IBaseLabelProvider)new FunctionsLabelProvider(this.lang));
                this.tableviewer.setComparator((ViewerComparator)new FunctionsSorter(this.lang));
                this.tableviewer.setInput((Object)FunctionFactory.getAvailableFunctions());
                if (this.tableviewer.getTable().getItemCount() != 0) {
                    this.tableviewer.getTable().setSelection(0);
                }
            }
            result = this.tableviewer;
        } else if (viewerclass.equals(ComboViewer.class)) {
            if (this.comboviewer == null) {
                this.comboviewer = new ComboViewer(this.parent, this.style);
                this.comboviewer.setContentProvider((IContentProvider)new FunctionsContentProvider());
                this.comboviewer.setLabelProvider((IBaseLabelProvider)new FunctionsLabelProvider(this.lang));
                this.comboviewer.setComparator((ViewerComparator)new FunctionsSorter(this.lang));
                this.comboviewer.setInput((Object)FunctionFactory.getAvailableFunctions());
                if (this.comboviewer.getCombo().getItemCount() != 0) {
                    this.comboviewer.getCombo().select(0);
                }
            }
            result = this.comboviewer;
        }
        return result;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }

    private class FunctionsContentProvider
    implements IStructuredContentProvider {
        private FunctionsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                return ((Set)inputElement).toArray(new Function[0]);
            }
            return new Function[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FunctionsLabelProvider
    extends LabelProvider {
        private String lang;

        public FunctionsLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof Function) {
                return CoreUtils.getCurrentLangName((Object)((Function)element), (String)this.lang);
            }
            return super.getText(element);
        }
    }

    protected class FunctionsSorter
    extends ViewerComparator {
        private String lang;

        public FunctionsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Function c1, Function c2) {
            String s1 = CoreUtils.getCurrentLangName((Object)c1, (String)this.lang);
            String s2 = CoreUtils.getCurrentLangName((Object)c2, (String)this.lang);
            return super.compare(viewer, (Object)s1, (Object)s2);
        }
    }
}

