/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.trees;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class DatasetsTreeContentProvider
implements ITreeContentProvider {
    private boolean showNotes = false;

    public DatasetsTreeContentProvider(boolean showNotes) {
        this.showNotes = showNotes;
    }

    public Object[] getElements(Object inputElement) {
        return TimeseriesServiceFactory.getService().getDatasets().toArray(new Dataset[0]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Dataset) {
            Dataset dataset = (Dataset)parentElement;
            ArrayList objectList = new ArrayList(dataset.getTimeseries());
            if (this.showNotes) {
                List notes = dataset.getNotes(ComponentsActivator.getLanguage());
                objectList.addAll(notes);
            }
            return objectList.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof DimensionNote) {
            return ((DimensionNote)element).getDataset();
        }
        if (element instanceof Timeseries) {
            return ((Timeseries)element).getDataset();
        }
        if (element instanceof Dataset) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Dataset;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

