/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.test;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.cache.ReferenceObjectCache;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReferenceTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void findByPreparedFinderTest() throws Exception {
        List list = ReferenceServiceHelper.getReferenceDAO("COUNTRY").findByAttribute("UN_CODE", String.class, (Object)"024");
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void getObjectByAttributeTest() throws Exception {
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        Attribute alpha3code = species.getAttribute("ALPHA_3_CODE");
        species.getObject(alpha3code, (Object)"YFT");
        ReferenceObjectCache cache = ReferenceObjectCache.getCache(species);
        Assert.assertNotNull((String)"Object not found in the cache", (Object)cache.get(alpha3code, "YFT"));
    }

    @Test
    public void getConceptsTest() throws Exception {
        for (Concept concept : ReferenceServiceFactory.getService().getConcepts()) {
            System.out.println(concept);
        }
    }

    @Test
    public void getReferenceObjectAttributesTest() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        ReferenceObject argentina = concept.getObject("UN_CODE", (Object)"032");
        System.out.println(argentina.getAttribute("NAME"));
    }

    @Test
    public void getParentRelationshipsTest() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Collection<Relationship> relationships = concept.getParentRelationships();
        for (Relationship relationship : relationships) {
            System.out.println(relationship.getAcronym());
        }
    }

    @Test
    public void getParentRelationshipsObjectsTest() throws Exception {
        Concept concept = ReferenceServiceFactory.getService().getConcept("AREA");
        Collection<Relationship> relationships = concept.getParentRelationships();
        for (Relationship relationship : relationships) {
            System.out.println(relationship.getAcronym());
            Set<ReferenceObject> parents = relationship.getParents();
            for (ReferenceObject parent : parents) {
                System.out.println(parent);
            }
        }
    }

    @Test
    public void getParentObjectsTest() throws Exception {
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("CONTINENT_COUNTRY");
        System.out.println("got relationship: " + relationship);
        for (ReferenceObject country_obj : country.getObjects()) {
            relationship.getParents(country_obj);
        }
    }

    @Test
    public void customGroupTest() throws Exception {
        Concept members = ReferenceServiceFactory.getService().getConcept("SPECIES");
        List<CustomGroup> groups = CustomGroupFactory.get(members);
        for (CustomGroup group : groups) {
            System.out.println(group);
        }
        CustomGroup the_group = CustomGroupFactory.get(IdentifierFactory.instance((String)"1"));
        System.out.println(the_group);
    }

    @Test
    public void createObjectTest() throws Exception {
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        ReferenceObject obj = test.createObject();
        obj.setAttribute("CODE", (Object)"999");
        obj.setAttribute("NAME", (Object)MultilingualString.NAME);
        obj.setAttribute("ADDRESS", (Object)"Viale Aventino");
        test.addObject(obj);
    }

    @Test
    public void removeObjectTest() throws Exception {
        Concept test = ReferenceServiceFactory.getService().getConcept("TEST");
        ReferenceObject obj = test.getObject("CODE", (Object)"999");
        test.removeObject(obj);
    }
}

