/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.WorkspaceStatus;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceSystemEntities;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceSystemEntitiesImpl;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesService;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;

public class CoreCommons {
    private static final WorkspaceSystemEntities workspaceSystemEntities = new WorkspaceSystemEntitiesImpl();
    private static final WorkspaceStatus status = new WorkspaceStatus();
    private static Concept languages;
    protected static WorkspacesManager workspaceManager;
    public static String LOCALE2;
    public static final VersionId COMPATIBILITY_MIN;
    public static final VersionId COMPATIBILITY_MAX;
    private static final TimeseriesService timeseriesService;

    static {
        workspaceManager = null;
        LOCALE2 = null;
        COMPATIBILITY_MIN = new VersionId("3.2.0");
        COMPATIBILITY_MAX = new VersionId("4.3.0");
        timeseriesService = TimeseriesServiceFactory.getService();
    }

    public static TimeseriesService getTimeseriesservice() {
        return timeseriesService;
    }

    public static WorkspaceSystemEntities getWorkspaceSystemEntities() {
        return workspaceSystemEntities;
    }

    public static WorkspaceStatus getWorkspaceStatus() {
        return status;
    }

    public static WorkspacesManager getWorkspacesManager() {
        if (workspaceManager == null) {
            workspaceManager = new WorkspacesManager(String.valueOf(Platform.getLocation().toOSString()) + File.separator);
        }
        return workspaceManager;
    }

    public static Concept getLanguages() {
        if (languages == null) {
            languages = ReferenceServiceFactory.getService().getConcept("LANGUAGE");
        }
        return languages;
    }

    public static boolean checkCompatibility(VersionId wsCompatibility) {
        if (wsCompatibility.getMajor() > COMPATIBILITY_MAX.getMajor()) {
            return false;
        }
        if (wsCompatibility.getMajor().equals(COMPATIBILITY_MAX.getMajor()) && wsCompatibility.getMinor() > COMPATIBILITY_MAX.getMinor()) {
            return false;
        }
        if (wsCompatibility.getMajor() < COMPATIBILITY_MIN.getMajor()) {
            return false;
        }
        return !wsCompatibility.getMajor().equals(COMPATIBILITY_MIN.getMajor()) || wsCompatibility.getMinor() >= COMPATIBILITY_MIN.getMinor();
    }
}

