/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.workspace;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.generated.workspaces.workspace.Workspace;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureExporter;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureImportExportLegacy;
import org.fao.fi.fishstat.core.workspaces.structure.WorkspaceStructureImporter;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceAdapters;
import org.osgi.framework.Bundle;

public class WorkspaceModelImpl
implements WorkspaceModel,
Cloneable,
PropertyChangeListener {
    private WorkspaceModel originalInstance;
    private File wsBaseDir;
    private String acronym = "";
    private VersionId version;
    private VersionId compatibility;
    private Date date;
    private MultilingualStringWrapper name = new MultilingualStringWrapper("name", this);
    private MultilingualStringWrapper description = new MultilingualStringWrapper("description", this);
    private MultilingualStringWrapper provider = new MultilingualStringWrapper("provider", this);
    private String dbAcronym;
    private String dbSchema = "FISHSTAT";
    private String dbUsername = "FISHSTAT";
    private String dbPassword = "";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public WorkspaceModelImpl(String xmlMessage, int version) throws Exception {
        this.readWorkspace(xmlMessage, version);
        this.originalInstance = this.clone();
    }

    @Override
    public void readWorkspace(String xmlMessage, int version) throws Exception {
        if (version == 2) {
            try {
                Workspace ws = WorkspaceStructureImporter.importWorkspace(xmlMessage);
                WorkspaceAdapters.getWorkspaceModel(this, ws);
            }
            catch (Exception jaxbException) {
                throw new Exception("Failed to import Workspace using JAXB ", jaxbException);
            }
            return;
        }
        try {
            WorkspaceStructureImportExportLegacy.readWorkspace(this, xmlMessage, false);
        }
        catch (Exception xmlException) {
            throw new Exception("Failed to import Workspace using XML  ", xmlException);
        }
    }

    public WorkspaceModelImpl(File wsPath) throws Exception {
        File descriptor = new File(wsPath, "ws2.xml");
        if (descriptor.exists()) {
            this.readWorkspace(CoreUtils.readFileUTF(descriptor), 2);
        } else {
            descriptor = new File(wsPath, "ws.xml");
            this.readWorkspace(CoreUtils.readFileUTF(descriptor), 1);
        }
        this.originalInstance = this.clone();
        this.wsBaseDir = wsPath;
    }

    public WorkspaceModelImpl() {
        this.acronym = "FAO_FI_GLOBAL_PROD";
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        this.version = new VersionId(String.valueOf(df.format(new Date())) + ".0.1");
        this.compatibility = CoreCommons.COMPATIBILITY_MAX.clone();
        this.date = new Date();
        this.wsBaseDir = new File(String.valueOf(Platform.getLocation().toString()) + File.separator + this.acronym + "_" + this.version.toString());
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return true;
        }
        if (!this.originalInstance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.originalInstance.getVersion().equals(this.version)) {
            return false;
        }
        if (!this.originalInstance.getName().getInstance().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getDescription().getInstance().equals((Object)this.description.getInstance())) {
            return false;
        }
        return this.originalInstance.getProvider().getInstance().equals((Object)this.provider.getInstance());
    }

    @Override
    public WorkspaceModel getInstance() {
        return this.originalInstance;
    }

    @Override
    public File getJarPath() {
        return new File(this.wsBaseDir, "jar" + File.separator + "fishstatj-jdbc-dao.jar");
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        File descriptor = new File(this.getWsBaseDir(), "ws2.xml");
        if (this.getWsBaseDir() != null && descriptor.exists()) {
            descriptor.delete();
        }
        WorkspaceStructureExporter.exportWorkspace(this, descriptor);
        this.originalInstance = this.clone();
        log.log((IStatus)new Status(1, this.getClass().getName(), "persisted ws.xml to " + this.wsBaseDir));
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public void setVersion(VersionId version) {
        this.version = version;
        this.propertyChangeSupport.firePropertyChange("version", this.version, this.version);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceModelImpl) {
            return ((WorkspaceModelImpl)obj).getWsBaseDir().equals(this.getWsBaseDir()) && ((WorkspaceModelImpl)obj).getAcronym().equals(this.getAcronym());
        }
        return false;
    }

    protected WorkspaceModelImpl clone() throws CloneNotSupportedException {
        WorkspaceModelImpl res = new WorkspaceModelImpl();
        res.acronym = new String(this.acronym);
        res.description = this.description.clone();
        res.name = this.name.clone();
        res.provider = this.provider.clone();
        res.dbAcronym = this.acronym;
        res.dbSchema = this.dbSchema;
        res.dbUsername = this.dbUsername;
        res.dbPassword = this.dbPassword;
        if (this.compatibility != null) {
            res.compatibility = this.compatibility.clone();
        }
        if (this.date != null) {
            res.date = (Date)this.date.clone();
        }
        if (this.wsBaseDir != null) {
            res.wsBaseDir = this.wsBaseDir;
        }
        if (this.version != null) {
            res.version = this.version != null ? this.version.clone() : null;
        }
        return res;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public File getAttachmentsDir() {
        return new File(this.wsBaseDir, "att");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setWsBaseDir(File locationDir) {
        this.wsBaseDir = locationDir;
        this.propertyChangeSupport.firePropertyChange("locationDir", this.wsBaseDir, this.wsBaseDir);
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public void setProvider(MultilingualStringWrapper provider) {
        this.provider = provider;
        this.propertyChangeSupport.firePropertyChange("provider", this.provider, this.provider);
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getDescription(String locale) {
        return this.description.getValue(locale);
    }

    @Override
    public File getWsBaseDir() {
        return this.wsBaseDir;
    }

    @Override
    public String getName(String locale) {
        return this.name.getValue(locale);
    }

    @Override
    public String getProvider(String locale) {
        return this.provider.getValue(locale);
    }

    @Override
    public VersionId getVersion() {
        return this.version;
    }

    @Override
    public VersionId getCompatibility() {
        return this.compatibility;
    }

    @Override
    public void setCompatibility(VersionId compatibility) {
        this.compatibility = compatibility;
    }

    @Override
    public File getSessionDir() {
        return new File(this.wsBaseDir, "session");
    }

    @Override
    public boolean hasAcronym() {
        return this.acronym != null;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
        this.propertyChangeSupport.firePropertyChange("date", this.date, this.date);
    }

    @Override
    public boolean hasDescription(String locale) {
        return this.description.getValue(locale) != null;
    }

    @Override
    public boolean hasName(String locale) {
        return this.name.getValue(locale) != null;
    }

    @Override
    public boolean hasProvider(String locale) {
        return this.provider.getValue(locale) != null;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getDbAcronym() {
        return this.dbAcronym;
    }

    @Override
    public String getDbUrl() throws Exception {
        if (this.wsBaseDir == null) {
            throw new Exception("wsBaseDir cannot be null");
        }
        return "jdbc:derby:" + this.wsBaseDir.getAbsolutePath() + File.separator + "db";
    }

    @Override
    public String getDbSchema() {
        return this.dbSchema;
    }

    @Override
    public String getDbUsername() {
        return this.dbUsername;
    }

    @Override
    public String getDbPassword() {
        return this.dbPassword;
    }

    @Override
    public void setDbAcronym(String dbAcronym) {
        this.dbAcronym = dbAcronym;
    }

    @Override
    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    @Override
    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    @Override
    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public MultilingualStringWrapper getProvider() {
        return this.provider;
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }
}

