/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.xmlbinds.workspaces;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.generated.multilingual.Multilingual;
import org.fao.fi.fishstat.core.generated.workspaces.attachments.Attachment;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Concept;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Relationship;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Attribute;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Dimension;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Timeseries;
import org.fao.fi.fishstat.core.generated.workspaces.workspace.Workspace;
import org.fao.fi.fishstat.core.model.attachment.AttachmentModel;
import org.fao.fi.fishstat.core.model.attachment.AttachmentModelImpl;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModelImpl;
import org.fao.fi.fishstat.core.model.concept.relationship.RelationshipModel;
import org.fao.fi.fishstat.core.model.concept.relationship.RelationshipModelImpl;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.DatasetModelImpl;
import org.fao.fi.fishstat.core.model.dataset.DimensionModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModelImpl;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.exceptions.TimeseriesManagementException;

public class WorkspaceAdapters {
    public static List<AttachmentModel> extractAttachments(List<Attachment> attachments) throws Exception {
        ArrayList<AttachmentModel> atdList = new ArrayList<AttachmentModel>();
        for (Attachment xmlAtt : attachments) {
            atdList.add(WorkspaceAdapters.getAttachment(xmlAtt));
        }
        return atdList;
    }

    private static AttachmentModel getAttachment(Attachment xmlAtt) throws Exception {
        if (xmlAtt.getAcronym() == null || xmlAtt.getDescription() == null || xmlAtt.getName() == null || xmlAtt.getTypeAttachment() == null || xmlAtt.getMimeType() == null || xmlAtt.getFileName() == null) {
            throw new Exception("A required attachment element is missing.");
        }
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset(xmlAtt.getDataset());
        if (dataset == null) {
            throw new Exception("not a valid dataset " + xmlAtt.getDataset());
        }
        AttachmentModelImpl res = new AttachmentModelImpl();
        res.setAcronym(xmlAtt.getAcronym());
        res.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlAtt.getName()));
        res.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xmlAtt.getDescription()));
        res.setType(AttachmentType.valueOf((String)xmlAtt.getTypeAttachment()));
        res.setDataset(dataset);
        res.setMimeType(xmlAtt.getMimeType());
        res.setFileName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlAtt.getFileName()));
        return res;
    }

    public static void checkAttachmentModel(AttachmentModel attModel) throws TimeseriesManagementException {
        if (attModel == null) {
            throw new TimeseriesManagementException("Attachment descriptor can not be null");
        }
        if (!AttachmentType.TYPES.contains(attModel.getType())) {
            throw new TimeseriesManagementException("Attachment type incorrect " + attModel.getType());
        }
        if (!AttachmentType.TYPES_MIMETYPES.containsKey(attModel.getMimeType())) {
            throw new TimeseriesManagementException("Attachment mimetype incorrect " + attModel.getMimeType());
        }
        if (attModel.getDescription().getInstance().getLength() > 399) {
            throw new TimeseriesManagementException("Description longer than 400; length=" + attModel.getDescription().getInstance().getLength());
        }
        if (attModel.getName().getInstance().getLength() > 79) {
            throw new TimeseriesManagementException("Name longer than 80; length=" + attModel.getName().getInstance().getLength());
        }
        if (attModel.getAcronym().length() > 49) {
            throw new TimeseriesManagementException("Acronym longer than 50; length=" + attModel.getAcronym().length());
        }
    }

    public static ConceptModel getConcept(Concept xmlConcept) throws Exception {
        if (xmlConcept.getAcronym() == null || xmlConcept.getName() == null || xmlConcept.getDescription() == null || xmlConcept.getSortOrder() == null) {
            throw new Exception("A required concept element is missing.");
        }
        ConceptModelImpl res = new ConceptModelImpl();
        res.setAcronym(xmlConcept.getAcronym());
        res.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlConcept.getName()));
        res.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xmlConcept.getDescription()));
        res.setSortorder(xmlConcept.getSortOrder());
        for (org.fao.fi.fishstat.core.generated.workspaces.concepts.Attribute xmlAttribute : xmlConcept.getAttributes().getAttribute()) {
            res.addAttribute(WorkspaceAdapters.getAttributeModel(res, xmlAttribute));
        }
        return res;
    }

    public static RelationshipModel getRelationshipModel(Relationship xmlRelationship) throws Exception {
        if (xmlRelationship.getAcronym() == null || xmlRelationship.getDescription() == null || xmlRelationship.getName() == null || xmlRelationship.getSortOrder() == null || xmlRelationship.getChild() == null || xmlRelationship.getParent() == null) {
            throw new Exception("A required relationship element is missing.");
        }
        RelationshipModelImpl res = new RelationshipModelImpl();
        res.setAcronym(xmlRelationship.getAcronym());
        res.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xmlRelationship.getDescription()));
        res.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlRelationship.getName()));
        res.setSortorder(xmlRelationship.getSortOrder());
        org.fao.fi.fishstat.data.reference.api.Concept childConcept = ReferenceServiceFactory.getService().getConcept(xmlRelationship.getChild());
        if (childConcept == null) {
            throw new Exception("Cannot import child concept for relationship " + xmlRelationship.getAcronym() + "." + xmlRelationship.getChild());
        }
        res.setChild(childConcept);
        org.fao.fi.fishstat.data.reference.api.Concept parentConcept = ReferenceServiceFactory.getService().getConcept(xmlRelationship.getParent());
        if (parentConcept == null) {
            throw new Exception("Cannot import parent concept for relationship " + xmlRelationship.getAcronym() + "." + xmlRelationship.getParent());
        }
        res.setParent(parentConcept);
        return res;
    }

    private static ConceptAttributeModel getAttributeModel(ConceptModel conceptModel, org.fao.fi.fishstat.core.generated.workspaces.concepts.Attribute xmlAttribute) throws Exception {
        if (xmlAttribute.getAcronym() == null || xmlAttribute.isIscode() == null || xmlAttribute.getDescription() == null || xmlAttribute.getName() == null || xmlAttribute.isIsname() == null || xmlAttribute.getScale() == null || xmlAttribute.getSize() == null || xmlAttribute.getType() == null) {
            throw new Exception("A required attribute element is missing.");
        }
        ConceptAttributeModel res = conceptModel.createNewAttribute();
        res.setAcronym(xmlAttribute.getAcronym());
        res.setCodeAttribute(xmlAttribute.isIscode());
        res.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xmlAttribute.getDescription()));
        res.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlAttribute.getName()));
        res.setNameAttribute(xmlAttribute.isIsname());
        res.setScale(xmlAttribute.getScale().shortValue());
        res.setSize(xmlAttribute.getSize().shortValue());
        res.setType(AttributeType.valueOf((String)xmlAttribute.getType()));
        return res;
    }

    private static String getCommonAttributeName(String common_name) {
        if (!common_name.startsWith("cm:")) {
            return common_name;
        }
        return common_name.substring(3).toUpperCase();
    }

    private static MultilingualStringWrapper toMultiLingualStringWrapper(Multilingual m) {
        MultilingualString ms = new MultilingualString();
        if (m != null) {
            ms.setValue("ar", m.getAr() != null ? m.getAr() : "");
            ms.setValue("en", m.getEn() != null ? m.getEn() : "");
            ms.setValue("es", m.getEs() != null ? m.getEs() : "");
            ms.setValue("fr", m.getFr() != null ? m.getFr() : "");
            ms.setValue("ru", m.getRu() != null ? m.getRu() : "");
            ms.setValue("zh", m.getZh() != null ? m.getZh() : "");
        }
        return new MultilingualStringWrapper(ms);
    }

    public static DatasetModel getDataset(org.fao.fi.fishstat.core.generated.workspaces.datasets.Dataset xml_dataset, ILog logger) throws Exception {
        if (xml_dataset.getAcronym() == null || xml_dataset.getUrl() == null || xml_dataset.getDatasource() == null || xml_dataset.getName() == null || xml_dataset.getDescription() == null || xml_dataset.getCitation() == null || xml_dataset.getVersion() == null || xml_dataset.getDate() == null) {
            throw new Exception("A required attribute element is missing.");
        }
        DatasetModelImpl dmRes = new DatasetModelImpl();
        dmRes.setAcronym(xml_dataset.getAcronym());
        dmRes.setUrl(xml_dataset.getUrl());
        dmRes.setDatasource(new DataSource(xml_dataset.getDatasource()));
        dmRes.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xml_dataset.getName()));
        dmRes.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xml_dataset.getDescription()));
        dmRes.setCitation(WorkspaceAdapters.toMultiLingualStringWrapper(xml_dataset.getCitation()));
        VersionId version = new VersionId();
        version.setAuthor(xml_dataset.getAuthor());
        version.setNumber(xml_dataset.getVersion());
        version.setDate(xml_dataset.getDate());
        dmRes.setVersion(version);
        logger.log((IStatus)new Status(1, WorkspaceAdapters.class.getName(), "found " + xml_dataset.getDimension().size() + " dimensions"));
        for (Dimension xmlDimension : xml_dataset.getDimension()) {
            dmRes.addDimension(WorkspaceAdapters.getDimensionModel(dmRes, xmlDimension, logger));
        }
        return dmRes;
    }

    public static TimeseriesModel getTimeseries(String dataset_acronym, Timeseries xml_timeseries) throws Exception {
        if (xml_timeseries.getAcronym() == null || xml_timeseries.getDatasource() == null || xml_timeseries.getFirstperiod() == null || xml_timeseries.getLastperiod() == null || xml_timeseries.getTimeresolution() == null || xml_timeseries.getName() == null || xml_timeseries.getDescription() == null) {
            throw new Exception("A required element is missing.");
        }
        TimeseriesModelImpl tsRes = new TimeseriesModelImpl(dataset_acronym);
        tsRes.setAcronym(xml_timeseries.getAcronym());
        tsRes.setDatasource(new DataSource(xml_timeseries.getDatasource()));
        tsRes.setFirstObservationPeriod(new ObservationPeriod(xml_timeseries.getFirstperiod()));
        tsRes.setLastObservationPeriod(new ObservationPeriod(xml_timeseries.getLastperiod()));
        tsRes.setTimeResolution(TimeResolution.valueOf((String)xml_timeseries.getTimeresolution()));
        tsRes.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xml_timeseries.getName()));
        tsRes.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xml_timeseries.getDescription()));
        for (Attribute attribute : xml_timeseries.getAttributes().getAttribute()) {
            if (attribute.getAcronym() == null || attribute.getValue() == null || attribute.getName() == null || attribute.getDescription() == null) {
                throw new Exception("A required attribute element is missing.");
            }
            TimeseriesAttributeModel attributeModel = tsRes.createNewAttribute();
            if (attribute.getAcronym().startsWith("cm:")) {
                attributeModel.setAcronym(WorkspaceAdapters.getCommonAttributeName(attribute.getAcronym()));
            } else {
                attributeModel.setAcronym(attribute.getAcronym());
            }
            attributeModel.setValue(attribute.getValue());
            attributeModel.setName(WorkspaceAdapters.toMultiLingualStringWrapper(attribute.getName()));
            attributeModel.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(attribute.getDescription()));
            tsRes.addAttribute(attributeModel);
        }
        return tsRes;
    }

    private static DimensionModel getDimensionModel(DatasetModel datasetModel, Dimension xmlDimension, ILog logger) throws Exception {
        logger.log((IStatus)new Status(1, WorkspaceAdapters.class.getName(), "adding dimension " + xmlDimension.getAcronym()));
        if (xmlDimension.getAcronym() == null || xmlDimension.getConcept() == null) {
            throw new Exception("A required field is missing.");
        }
        DimensionModel dimRes = datasetModel.createNewDimension();
        dimRes.setAcronym(xmlDimension.getAcronym());
        org.fao.fi.fishstat.data.reference.api.Concept concept = ReferenceServiceFactory.getService().getConcept(xmlDimension.getConcept());
        if (concept == null) {
            logger.log((IStatus)new Status(4, WorkspaceAdapters.class.getName(), "canot get concept for " + xmlDimension.getConcept()));
            return null;
        }
        dimRes.setConcept(concept);
        if (xmlDimension.getAttribute() == null) {
            logger.log((IStatus)new Status(4, WorkspaceAdapters.class.getName(), "canot get attribute for " + xmlDimension.getAttribute()));
        }
        dimRes.setAttribute(concept.getAttribute(xmlDimension.getAttribute()));
        if (xmlDimension.getName() == null) {
            logger.log((IStatus)new Status(4, WorkspaceAdapters.class.getName(), "canot get name for " + xmlDimension.getName()));
        }
        dimRes.setName(WorkspaceAdapters.toMultiLingualStringWrapper(xmlDimension.getName()));
        if (xmlDimension.getDescription() == null) {
            logger.log((IStatus)new Status(4, WorkspaceAdapters.class.getName(), "canot get description for " + xmlDimension.getDescription()));
        }
        dimRes.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(xmlDimension.getDescription()));
        dimRes.setMeasure(xmlDimension.isIsmeasure());
        dimRes.setHasNote(xmlDimension.isHasnote());
        return dimRes;
    }

    public static Workspace convertWorkspace(WorkspaceModel w4Model) throws DatatypeConfigurationException {
        Workspace w4 = new Workspace();
        w4.setAcronym(w4Model.getAcronym());
        w4.setCompatibility(w4Model.getCompatibility().getNumber());
        GregorianCalendar gc = new GregorianCalendar();
        if (w4Model.getDate() != null) {
            gc.setTime(w4Model.getDate());
            w4.setDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
        }
        Workspace.Dbms dbms = new Workspace.Dbms();
        dbms.setAcronym(w4Model.getDbAcronym());
        dbms.setPassword(w4Model.getDbPassword());
        dbms.setSchema(w4Model.getDbSchema());
        dbms.setUsername(w4Model.getDbUsername());
        w4.setDbms(dbms);
        w4.setDescription(WorkspaceAdapters.toMultilingual(w4Model.getDescription()));
        w4.setName(WorkspaceAdapters.toMultilingual(w4Model.getName()));
        w4.setProvider(WorkspaceAdapters.toMultilingual(w4Model.getProvider()));
        w4.setVersion(w4Model.getVersion().getNumber());
        return w4;
    }

    public static void getWorkspaceModel(WorkspaceModel wks, Workspace ws) throws Exception {
        if (ws.getAcronym() == null || ws.getDate() == null || ws.getDescription() == null || ws.getName() == null || ws.getProvider() == null || ws.getVersion() == null || ws.getDbms() == null || ws.getDbms().getSchema() == null || ws.getDbms().getUsername() == null || ws.getDbms().getPassword() == null) {
            throw new Exception("A required field is missing.");
        }
        wks.setAcronym(ws.getAcronym());
        wks.setCompatibility(new VersionId(ws.getCompatibility()));
        wks.setDate(ws.getDate().toGregorianCalendar().getTime());
        wks.setDescription(WorkspaceAdapters.toMultiLingualStringWrapper(ws.getDescription()));
        wks.setName(WorkspaceAdapters.toMultiLingualStringWrapper(ws.getName()));
        wks.setProvider(WorkspaceAdapters.toMultiLingualStringWrapper(ws.getProvider()));
        wks.setVersion(new VersionId(ws.getVersion()));
        wks.setDbAcronym(ws.getDbms().getAcronym());
        wks.setDbUsername(ws.getDbms().getUsername());
        wks.setDbPassword(ws.getDbms().getPassword());
        wks.setDbSchema(ws.getDbms().getSchema());
    }

    public static MultilingualString toMultilingualString(Multilingual mlFromSchema) {
        MultilingualString mlString = new MultilingualString();
        mlString.setValue("en", WorkspaceAdapters.getString(mlFromSchema.getEn()));
        mlString.setValue("fr", WorkspaceAdapters.getString(mlFromSchema.getFr()));
        mlString.setValue("es", WorkspaceAdapters.getString(mlFromSchema.getEs()));
        mlString.setValue("ar", WorkspaceAdapters.getString(mlFromSchema.getAr()));
        mlString.setValue("ru", WorkspaceAdapters.getString(mlFromSchema.getRu()));
        mlString.setValue("zh", WorkspaceAdapters.getString(mlFromSchema.getZh()));
        return mlString;
    }

    private static String getString(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        return xmlString;
    }

    public static Multilingual ToMutilingual(MultilingualString mlString) {
        Multilingual ml = new Multilingual();
        ml.setEn(mlString.getValue("en"));
        ml.setFr(mlString.getValue("fr"));
        ml.setEs(mlString.getValue("es"));
        ml.setAr(mlString.getValue("ar"));
        ml.setRu(mlString.getValue("ru"));
        ml.setZh(mlString.getValue("zh"));
        return ml;
    }

    public static Multilingual toMultilingual(MultilingualStringWrapper mlsw) {
        Multilingual ml = new Multilingual();
        if (mlsw != null) {
            ml.setAr(mlsw.getValue("ar") != null ? mlsw.getValue("ar") : "");
            ml.setEn(mlsw.getValue("en") != null ? mlsw.getValue("en") : "");
            ml.setEs(mlsw.getValue("es") != null ? mlsw.getValue("es") : "");
            ml.setFr(mlsw.getValue("fr") != null ? mlsw.getValue("fr") : "");
            ml.setRu(mlsw.getValue("ru") != null ? mlsw.getValue("ru") : "");
            ml.setZh(mlsw.getValue("zh") != null ? mlsw.getValue("zh") : "");
        }
        return ml;
    }
}

