/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.model.functions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.data.timeseries.api.FAOMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.FunctionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.AggregatePeriod;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;

public class CalculatedMeasureDefinitionWrapper {
    private String id;
    private CalculatedMeasuresProperties properties;
    private CalculatedMeasureDefinition measure;

    public CalculatedMeasureDefinitionWrapper(CalculatedMeasuresProperties properties, CalculatedMeasureDefinition measure) {
        this.measure = measure;
        this.id = "timeseries." + properties.getTimeseries().getAcronym() + ".measures." + properties.size();
    }

    public CalculatedMeasureDefinitionWrapper(CalculatedMeasuresProperties properties, int idx) {
        this.id = "timeseries." + properties.getTimeseries().getAcronym() + ".measures." + idx;
        this.loadDefinitionProperties(properties.getTimeSeriesProperties().getPreferenceStore());
    }

    public static String[] getFilteredPreferences(PreferenceStore store, String prefix) {
        String[] labels = store.preferenceNames();
        Vector<String> result = new Vector<String>(labels.length);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label.startsWith(prefix)) {
                result.add(label);
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public void saveDefinitionProperties(PreferenceStore store) {
        store.setValue(String.valueOf(this.id) + ".name", this.measure.getName());
        store.setValue(String.valueOf(this.id) + ".function", this.measure.getFunction().getAcronym());
        store.setValue(String.valueOf(this.id) + ".minvalue", this.measure.getMinValue());
        store.setValue(String.valueOf(this.id) + ".maxvalue", this.measure.getMaxValue());
        if (this.measure.getSkipStatus() != null && this.measure.getSkipStatus().contains(FAOMeasureStatus.OFFICIAL)) {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "A".toString(), "true");
        } else {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "A".toString(), "false");
        }
        if (this.measure.getSkipStatus() != null && this.measure.getSkipStatus().contains(FAOMeasureStatus.MISSING)) {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "M".toString(), "true");
        } else {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "M".toString(), "false");
        }
        if (this.measure.getSkipStatus() != null && this.measure.getSkipStatus().contains(FAOMeasureStatus.NEGLIBILE)) {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "N", "true");
        } else {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "N", "false");
        }
        if (this.measure.getSkipStatus() != null && this.measure.getSkipStatus().contains(FAOMeasureStatus.ZERO)) {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "O", "true");
        } else {
            store.setValue(String.valueOf(this.id) + ".skipstatus." + "O", "false");
        }
        if (this.measure.getParameters() != null) {
            for (Parameter parameter : this.measure.getParameters().keySet()) {
                store.setValue(String.valueOf(this.id) + ".params." + parameter.getAcronym(), (String)this.measure.getParameters().get(parameter));
            }
        }
    }

    public void loadDefinitionProperties(PreferenceStore store) {
        this.measure = CalculatedMeasureDefinitionFactory.create((String)store.getString(String.valueOf(this.id) + ".name"));
        this.measure.setFunction(FunctionFactory.getFunction((String)store.getString(String.valueOf(this.id) + ".function")));
        this.measure.setMinValue(store.getDouble(String.valueOf(this.id) + ".minvalue"));
        this.measure.setMaxValue(store.getDouble(String.valueOf(this.id) + ".maxvalue"));
        String[] skipids = CalculatedMeasureDefinitionWrapper.getFilteredPreferences(store, String.valueOf(this.id) + ".skipstatus.");
        if (skipids.length > 0) {
            HashSet<MeasureStatus> status = new HashSet<MeasureStatus>();
            String[] stringArray = skipids;
            int n = skipids.length;
            int n2 = 0;
            while (n2 < n) {
                String skipid = stringArray[n2];
                String symbol = skipid.substring((String.valueOf(this.id) + ".skipstatus.").length());
                if (store.getString(String.valueOf(this.id) + ".skipstatus." + symbol).equals("true")) {
                    status.add(new MeasureStatus(symbol));
                }
                ++n2;
            }
            this.measure.setSkipStatus(status);
        }
        if (this.measure.getFunction().getParameters() != null) {
            HashMap<Parameter, String> measureparams = new HashMap<Parameter, String>(this.measure.getFunction().getParameters().size());
            for (Parameter parameter : this.measure.getFunction().getParameters()) {
                measureparams.put(parameter, store.getString(String.valueOf(this.id) + ".params." + parameter.getAcronym()));
            }
            this.measure.setParameters(measureparams);
        }
    }

    public boolean hasExtraParameters() {
        if (this.measure != null && this.measure.getFunction() != null) {
            return this.measure.getFunction().getParameters() != null;
        }
        return false;
    }

    public Set<ParameterWrapper> getExtraParameters() {
        TreeSet<ParameterWrapper> result = null;
        if (this.measure.getParameters() != null) {
            result = new TreeSet<ParameterWrapper>();
            for (Parameter parameter : this.measure.getParameters().keySet()) {
                result.add(new ParameterWrapper(parameter, (String)this.measure.getParameters().get(parameter)));
            }
        }
        return result;
    }

    public CalculatedMeasureDefinition getMeasure() {
        return this.measure;
    }

    public CalculatedMeasuresProperties getProperties() {
        return this.properties;
    }

    public String getMeasureName() {
        if (this.measure != null) {
            return this.measure.getName();
        }
        return "";
    }

    public String getMeasureLabel() {
        if (this.getMeasure().getFunction() instanceof AggregatePeriod) {
            Map pars2 = this.getMeasure().getParameters();
            return (String)pars2.entrySet().iterator().next().getValue();
        }
        return this.getMeasureName();
    }

    public List<ObservationPeriod> getPeriods() {
        return this.measure != null ? this.measure.getPeriods() : null;
    }

    public void setPeriods(List<ObservationPeriod> periods) {
        if (this.measure != null) {
            this.measure.setPeriods(periods);
        }
    }
}

