/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModel;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupsDaoFactory;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;

public class DimensionProperties
extends Observable
implements IFSActions {
    public static final int SELECTION_FROM_ALL = 0;
    public static final int SELECTION_FROM_INVOLVED = 1;
    public static final int SELECTION_FROM_CUSTOM_GROUP = 2;
    protected String id;
    protected DatasetProperties datasetProperties;
    protected Dimension dimension;
    protected int dimensionIdx;
    protected int selectionMode;
    protected CustomGroupModel selectorSource;
    protected Vector<ConceptProperties> descriptors = new Vector(1);
    protected LinkedHashMap<String, ConceptProperties> selectors = new LinkedHashMap(1);

    public DimensionProperties(DatasetProperties dp, Dimension dm, int idx) {
        this.datasetProperties = dp;
        this.dimension = dm;
        this.dimensionIdx = idx;
        this.id = "dimension." + this.dimension.getConcept().getAcronym();
        this.createDefaults(this.datasetProperties.getPreferenceStore());
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Concept getDimensionConcept() {
        return this.dimension.getConcept();
    }

    public int getDimensionIdx() {
        return this.dimensionIdx;
    }

    public void addDescriptor(ConceptProperties d) {
        if (!this.descriptors.contains(d)) {
            this.descriptors.add(d);
            this.datasetProperties.addAction(21, 91);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getDescriptorsSize() {
        return this.descriptors.size();
    }

    public void removeDescriptor(int idx) {
        this.descriptors.remove(idx);
        int i = 0;
        while (i < this.descriptors.size()) {
            this.descriptors.get((int)i).id = String.valueOf(this.id) + ".descriptor." + i;
            ++i;
        }
        this.datasetProperties.addAction(21, 91);
        this.setChanged();
        this.notifyObservers();
    }

    public DatasetProperties getDatasetProperties() {
        return this.datasetProperties;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        this.setChanged();
        this.datasetProperties.addAction(21);
    }

    public CustomGroupModel getSelectorSource() {
        return this.selectorSource;
    }

    public boolean hasSelectorSource() {
        return this.selectorSource != null;
    }

    public void setSelectorSource(CustomGroupModel selectorSource) {
        this.selectorSource = selectorSource;
    }

    public Vector<ConceptProperties> getDescriptors() {
        return this.descriptors;
    }

    public ConceptProperties getDescriptor(int idx) {
        return this.descriptors.get(idx);
    }

    public Collection<ConceptProperties> getSelectors() {
        return this.selectors.values();
    }

    public ConceptProperties getSelector(String concept_name) {
        return this.selectors.get(concept_name);
    }

    public ConceptProperties newDescriptor() {
        String descriptor_id = String.valueOf(this.id) + ".descriptor." + this.descriptors.size();
        ConceptProperties dcp = new ConceptProperties(this, descriptor_id, 1, this.dimension.getConcept());
        return dcp;
    }

    private void createDefaults(PreferenceStore store) {
        store.setDefault(String.valueOf(this.id) + ".descriptors.size", 1);
        store.setDefault(String.valueOf(this.id) + ".selection_mode", 1);
    }

    protected void loadProperties(PreferenceStore store) {
        int descriptors_size = store.getInt(String.valueOf(this.id) + ".descriptors.size");
        this.descriptors = new Vector(descriptors_size);
        int i = 0;
        while (i < descriptors_size) {
            this.descriptors.add(new ConceptProperties(this, String.valueOf(this.id) + ".descriptor." + i, 1, this.dimension.getConcept()).loadProperties(store));
            ++i;
        }
        this.selectionMode = store.getInt(String.valueOf(this.id) + ".selection_mode");
        if (this.selectionMode == 2) {
            int source_id = store.getInt(String.valueOf(this.id) + ".selection_source");
            this.selectorSource = source_id > 0 ? CustomGroupsDaoFactory.create().get(IdentifierFactory.instance((int)source_id)) : null;
        }
        String dimid = String.valueOf(this.id) + ".selector." + this.dimension.getConcept().getAcronym();
        this.selectors.put(this.dimension.getConcept().getAcronym(), new ConceptProperties(this, dimid, 2, this.dimension.getConcept()).loadProperties(store));
        List parents = CoreUtils.getChilds((Concept)this.dimension.getConcept());
        int i2 = 0;
        while (i2 < parents.size()) {
            String id2 = String.valueOf(this.id) + ".selector." + ((Concept)parents.get(i2)).getAcronym();
            ConceptProperties cdp = new ConceptProperties(this, id2, 2, (Concept)parents.get(i2));
            cdp.loadProperties(store);
            this.selectors.put(((Concept)parents.get(i2)).getAcronym(), cdp);
            ++i2;
        }
    }

    public void storeProperties() {
        PreferenceStore store = this.datasetProperties.getPreferenceStore();
        store.setValue(String.valueOf(this.id) + ".descriptors.size", this.descriptors.size());
        store.setValue(String.valueOf(this.id) + ".selection_mode", this.selectionMode);
        if (this.selectionMode == 2) {
            if (this.selectorSource == null) {
                store.setValue(String.valueOf(this.id) + ".selection_source", 0);
            } else {
                store.setValue(String.valueOf(this.id) + ".selection_source", this.selectorSource.getId().intValue());
            }
        }
        for (ConceptProperties descriptor : this.descriptors) {
            descriptor.storeProperties();
        }
        for (ConceptProperties selector : this.selectors.values()) {
            selector.storeProperties();
        }
    }

    @Override
    protected synchronized void setChanged() {
        super.setChanged();
    }

    public Set<ReferenceObject> getAllReferenceData() {
        HashSet<Object> refset = new HashSet<ReferenceObject>();
        if (this.selectionMode == 1) {
            for (Timeseries ts : this.getDatasetProperties().getDataset().getTimeseries()) {
                Collection used = ts.getAllReferencedObjects(this.dimension);
                refset.addAll(used);
            }
        } else if (this.selectionMode == 2) {
            if (this.hasSelectorSource()) {
                refset = new HashSet(this.selectorSource.getSelection().getIncludes());
            }
        } else {
            refset = new HashSet(this.dimension.getConcept().getObjects());
        }
        return refset;
    }
}

