/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.session;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.fao.fi.fishstat.core.FSActions;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.data.common.utils.RuntimeMemory;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.PropertiesFactory;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.FSGuiSessionMetadata;
import org.osgi.framework.Bundle;

public class GuiSession
extends Session {
    private DatasetProperties datasetProperties;

    public GuiSession(Timeseries timeseries) {
        super(timeseries);
        this.datasetProperties = PropertiesFactory.getProperties(timeseries.getDataset());
        this.datasetProperties.addObserver((Observer)((Object)this));
        this.sessionMetadata = new FSGuiSessionMetadata(this);
    }

    public GuiSession(SessionDescriptor descriptor) {
        super(descriptor);
        this.datasetProperties = PropertiesFactory.getProperties(descriptor.getDataset());
        this.datasetProperties.addObserver((Observer)((Object)this));
        this.sessionMetadata = new FSGuiSessionMetadata(this);
    }

    public DatasetProperties getDatasetProperties() {
        return this.datasetProperties;
    }

    public TimeSeriesProperties getTimeseriesProperties() {
        String acronym = this.descriptor.getTimeseries().getAcronym();
        return this.datasetProperties.getTimeSeriesProperties(acronym);
    }

    public boolean hasCalculatedMesaures() {
        return this.getTimeseriesProperties().hasCalculatedMesaureProperties();
    }

    private void reAlignCalculateMesaures(Timeseries ts) {
        ts.removeCalculatedMeasureDefinitions(ts.getCalculatedMeasureDefinitions());
        Map<String, CalculatedMeasureDefinitionWrapper> wrappers = this.getTimeseriesProperties().getCalculatedMesaureProperties().getMeasures();
        LinkedList<CalculatedMeasureDefinition> toAdd = new LinkedList<CalculatedMeasureDefinition>();
        for (CalculatedMeasureDefinitionWrapper wrapper : wrappers.values()) {
            wrapper.setPeriods(this.getTimeseriesProperties().getPeriods());
            toAdd.add(wrapper.getMeasure());
        }
        ts.addCalculatedMeasureDefinitions(toAdd);
    }

    public void update(Observable arg0, Object arg1) {
        FSActions newActions;
        if (arg0 instanceof DatasetProperties) {
            this.datasetProperties = PropertiesFactory.getProperties(this.descriptor.getDataset());
            this.sessionMetadata = new FSGuiSessionMetadata(this);
            if (arg1 instanceof FSActions && (newActions = (FSActions)arg1).size() > 0) {
                this.actions.addAll(newActions);
            }
            this.addAction(42);
            this.notifyMultiTableView();
        }
        if (arg1 instanceof FSActions) {
            newActions = (FSActions)arg1;
            this.actions.addAll(newActions);
            if (newActions.contains(Integer.valueOf(33))) {
                this.reAlignCalculateMesaures(this.lastResult);
            }
            if (newActions.contains(Integer.valueOf(11))) {
                this.compute("", (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.notifyMultiTableView();
            }
        }
    }

    public void compute(String message, IProgressMonitor pm) {
        try {
            if (pm != null) {
                pm.beginTask(message, 22);
            }
            if (pm != null) {
                pm.worked(1);
            }
            long maxMemory = RuntimeMemory.maxMemory();
            long usgMemory = RuntimeMemory.usedMemory();
            if ((float)usgMemory / (float)maxMemory > 0.5f) {
                this.setChanged();
                this.notifyObservers("VIEW_FLUSH");
            }
            if (pm != null) {
                pm.worked(1);
            }
            if (this.lastResult == null) {
                this.lastResult = this.descriptor.getTimeseries();
                this.actions.add(Integer.valueOf(41));
                this.tsResetRequired = false;
            }
            if (pm != null) {
                pm.worked(1);
            }
            this.reAlignCalculateMesaures(this.lastResult);
            if (pm != null) {
                pm.worked(2);
            }
            if (this.tsResetRequired) {
                this.lastResult.reset();
                this.notifyObservers("VIEW_FLUSH");
                this.tsResetRequired = false;
            }
            if (pm != null) {
                pm.worked(2);
            }
            if (this.filterRequest != null) {
                this.lastResult = this.descriptor.getTimeseries();
                this.lastResult.filter(this.filterRequest.getActionRequest());
            }
            if (pm != null) {
                pm.worked(2);
            }
            this.lastResult.createGandTotals();
            if (pm != null) {
                pm.worked(2);
            }
            if (this.aggregationRequest != null) {
                System.out.println("GuiSession.compute(): ERROR, aggregationRequest is not null; normally is null");
                this.lastResult.aggregate(this.aggregationRequest.getActionRequest());
            }
            if (pm != null) {
                pm.worked(2);
            }
            if (this.topOthersRequest != null) {
                if (this.topOthersRequest.getType() == 1) {
                    this.lastResult.aggregate(this.topOthersRequest.getActionRequest(), ObservationPeriod.valueOf((String)this.topOthersRequest.getPeriod_id()));
                } else if (this.topOthersRequest.getType() == 2) {
                    this.lastResult.aggregate(this.topOthersRequest.getActionRequest(), this.lastResult.getCalculatedMeasureDefinition(this.topOthersRequest.getCalcColName()));
                }
                this.actions.add(Integer.valueOf(43));
            }
            if (pm != null) {
                pm.worked(2);
            }
            this.currentSize = this.lastResult.getObservations().size();
            if (pm != null) {
                pm.worked(2);
            }
            this.sessionMetadata = new FSGuiSessionMetadata(this);
            if (pm != null) {
                pm.worked(2);
            }
            this.notifyMultiTableView();
            if (pm != null) {
                pm.worked(3);
            }
            if (pm != null) {
                pm.done();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MessageDialog.openError(null, (String)"FishStatJ out of memory", (String)"Sorry, cannot continue (GuiSession).");
            System.exit(1);
        }
        catch (ConcurrentModificationException e) {
            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, ((Object)((Object)this)).getClass().getName(), "compute error", (Throwable)e));
        }
    }

    public void dispose() {
        this.datasetProperties.deleteObserver((Observer)((Object)this));
        this.datasetProperties = null;
        this.filterRequest = null;
        this.aggregationRequest = null;
        this.topOthersRequest = null;
        if (this.lastResult != null) {
            try {
                this.lastResult.reset();
                this.lastResult = null;
            }
            catch (Exception e) {
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, ((Object)((Object)this)).getClass().getName(), "dispose error", (Throwable)e));
            }
        }
    }
}

