/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.util.Set;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class CustomGroupImpl
implements CustomGroup {
    private ReferenceObject customGroupObject;
    private Concept membersConcept;
    private Relationship relationship;

    public CustomGroupImpl(ReferenceObject customGroupObject, Concept membersConcept) throws ReferenceServiceException {
        this.customGroupObject = customGroupObject;
        this.membersConcept = membersConcept;
        this.relationship = ReferenceServiceFactory.getService().getRelationship(String.valueOf(customGroupObject.getConcept().getAcronym()) + "_" + membersConcept.getAcronym());
    }

    @Override
    public Identifier getId() throws ReferenceServiceException {
        return this.customGroupObject.getId();
    }

    @Override
    public void addMember(ReferenceObject member) throws ReferenceServiceException {
        if (member == null) {
            throw new IllegalArgumentException("Custom group member can not be null");
        }
        if (!member.getConcept().equals(this.membersConcept)) {
            throw new IllegalArgumentException("Custom group member concept must be an instance of " + this.membersConcept.getAcronym() + ", found " + member.getConcept().getAcronym());
        }
        this.relationship.add(this.customGroupObject, member);
    }

    @Override
    public Set<ReferenceObject> getMembers() throws ReferenceServiceException {
        return this.relationship.getChildren(this.customGroupObject);
    }

    @Override
    public Concept getMembersConcept() throws ReferenceServiceException {
        return this.membersConcept;
    }

    @Override
    public MultilingualString getName() throws ReferenceServiceException {
        return (MultilingualString)this.customGroupObject.getAttribute("NAME");
    }

    @Override
    public void removeMember(ReferenceObject member) throws ReferenceServiceException {
        this.relationship.remove(this.customGroupObject, member);
    }

    @Override
    public void setName(MultilingualString name) throws ReferenceServiceException {
        this.customGroupObject.setAttribute("NAME", (Object)name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.customGroupObject == null ? 0 : this.customGroupObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomGroupImpl)) {
            return false;
        }
        CustomGroupImpl other = (CustomGroupImpl)obj;
        return !(this.customGroupObject == null ? other.customGroupObject != null : !this.customGroupObject.equals(other.customGroupObject));
    }

    @Override
    public MultilingualString getDescription() throws ReferenceServiceException {
        return (MultilingualString)this.customGroupObject.getAttribute("DESCRIPTION");
    }

    @Override
    public void setDescription(MultilingualString description) throws ReferenceServiceException {
        this.customGroupObject.setAttribute("DESCRIPTION", (Object)description);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.customGroupObject).append(this.membersConcept);
        return buffer.toString();
    }

    @Override
    public void addMembers(Set<ReferenceObject> members) throws ReferenceServiceException {
        if (members == null) {
            throw new IllegalArgumentException("Custom group members set can not be null");
        }
        for (ReferenceObject member : members) {
            this.addMember(member);
        }
    }

    @Override
    public void removeMembers(Set<ReferenceObject> members) throws ReferenceServiceException {
        if (members == null) {
            throw new IllegalArgumentException("Custom group members set can not be null");
        }
        for (ReferenceObject member : members) {
            this.removeMember(member);
        }
    }

    @Override
    public void cleanMembers() throws ReferenceServiceException {
        this.relationship.setChildren(this.customGroupObject, null);
    }

    @Override
    public ReferenceObject getObject() throws ReferenceServiceException {
        return this.customGroupObject;
    }

    @Override
    public boolean contains(ReferenceObject member) throws ReferenceServiceException {
        return this.relationship.contains(this.customGroupObject, member);
    }
}

