/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.gui.Activator;

public class LogDiagnosticReporting {
    private ArrayList<String> fishstatjLog = new ArrayList();
    private String messageLOGFILEmailed = "Logfile mailed";
    private String messageLOGFILEopened = "Logfile opened";

    public LogDiagnosticReporting() {
        if (!this.readLogFile()) {
            return;
        }
        int indexStart = this.checkFilterLog();
        if (indexStart == -1) {
            return;
        }
        String textFilePath = this.copyLogFile(indexStart);
        if (textFilePath == null) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        if (shell == null) {
            shell = Display.getDefault().getActiveShell();
        }
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (System.getProperty("user.name").compareToIgnoreCase("berger") == 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), this.messageLOGFILEmailed));
            return;
        }
        String outlookPath = this.findOutlook();
        if (outlookPath == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Diagnostic information - send email", (String)"In order to improve FishStatJ, we are asking your assistance\nto submit the logfile [mail.txt] by email.\n\nPlease send [mail.txt] to [Fish-Statistics-Inquiries@fao.org]");
            try {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(new File(textFilePath).getParentFile());
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "open folder", (Throwable)e));
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), this.messageLOGFILEopened));
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"Diagnostic information - send email", (String)"In order to improve FishStatJ, we are asking your assistance\nto submit diagnostic information by email.\n\nPlease click on the [Send], to submit the information");
            try {
                String body = "This message contains the diagnostic log-file of FishStatJ attached.\n\nPlease send the email; it helps us improve the program.\n\nyour FishStatJ support team";
                new ProcessBuilder(outlookPath, "/m", "\"Fish-Statistics-Inquiries@fao.org?subject=FishStatJ diagnostic information&body=" + body + "\"", "/a", textFilePath).start();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "open outlook", (Throwable)e));
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), this.messageLOGFILEmailed));
        }
    }

    private String copyLogFile(int startIndex) {
        String textFilePath = String.valueOf(Platform.getLogFileLocation().toFile().getParent()) + File.separator + "mail.txt";
        try {
            Files.deleteIfExists(Paths.get(textFilePath, new String[0]));
        }
        catch (IOException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "delete old mail.txt", (Throwable)e1));
        }
        try {
            Throwable e1 = null;
            Object var4_7 = null;
            try (BufferedWriter myWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(textFilePath), "UTF-8"));){
                myWriter.write("Please send this file to\r\n\r\n");
                myWriter.write("Fish-Statistics-Inquiries@fao.org\r\n\r\n");
                myWriter.write("your FishStatJ support team\r\n\r\n");
                int i = startIndex;
                while (i < this.fishstatjLog.size()) {
                    myWriter.write(this.fishstatjLog.get(i));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (e1 == null) {
                    e1 = throwable;
                } else if (e1 != throwable) {
                    e1.addSuppressed(throwable);
                }
                throw e1;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "write new mail.txt", (Throwable)e));
            return null;
        }
        return textFilePath;
    }

    /*
     * Unable to fully structure code
     */
    private int checkFilterLog() {
        dateFmt = new SimpleDateFormat("yyyy-MM");
        lastMonth = Calendar.getInstance();
        lastMonth.setTime(new Date());
        lastMonth.add(2, -1);
        filterDate = dateFmt.format(lastMonth.getTime());
        indexStart = 0;
        i = 0;
        while (i < this.fishstatjLog.size()) {
            if (this.fishstatjLog.get(i).indexOf(filterDate) != -1) {
                indexStart = i;
                break;
            }
            ++i;
        }
        i = indexStart;
        while (i < this.fishstatjLog.size()) {
            if (this.fishstatjLog.get(i).indexOf("!MESSAGE " + this.messageLOGFILEmailed) != -1 || this.fishstatjLog.get(i).indexOf("!MESSAGE " + this.messageLOGFILEopened) != -1) {
                indexStart = i;
            }
            ++i;
        }
        foundNPE = false;
        i = indexStart;
        while (i < this.fishstatjLog.size()) {
            if (this.fishstatjLog.get(i).startsWith("!STACK")) {
                foundNPE = true;
                break;
            }
            ++i;
        }
        if (foundNPE) ** GOTO lbl32
        return -1;
        while (!this.fishstatjLog.get(indexStart).equals("-------------------------------")) {
            --indexStart;
lbl32:
            // 2 sources

            if (indexStart > 0) continue;
        }
        return indexStart;
    }

    private boolean readLogFile() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Platform.getLogFileLocation().toString()), "UTF-8"));){
                String line = br.readLine();
                while (line != null) {
                    this.fishstatjLog.add(String.valueOf(line) + System.lineSeparator());
                    line = br.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "reading log", (Throwable)e));
            return false;
        }
        return !this.fishstatjLog.isEmpty();
    }

    private String findOutlook() {
        String extensionType;
        BufferedReader input;
        Process p;
        block5: {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("mac") != -1) {
                return null;
            }
            p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "assoc", ".pst"});
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            extensionType = input.readLine();
            input.close();
            if (extensionType != null) break block5;
            return null;
        }
        try {
            String[] fileType = extensionType.split("=");
            p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "ftype", fileType[1]});
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String fileAssociation = input.readLine();
            Pattern pattern = Pattern.compile("\".*?\"");
            Matcher m = pattern.matcher(fileAssociation);
            if (m.find()) {
                String outlookPath = m.group(0);
                return outlookPath;
            }
        }
        catch (Exception err) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "locating outlook", (Throwable)err));
        }
        return null;
    }

    private String getOutlookPath() {
        String path = null;
        path = this.getOfficeVersionPath("C:\\Program Files (x86)\\Microsoft Office 2010");
        if (path != null) {
            return path;
        }
        path = this.getOfficeVersionPath("C:\\Program Files (x86)\\Microsoft Office");
        if (path != null) {
            return path;
        }
        path = this.getOfficeVersionPath("C:\\Program Files\\Microsoft Office");
        if (path != null) {
            return path;
        }
        return null;
    }

    private String getOfficeVersionPath(String pathBase) {
        String constOUTLOOKexe = "OUTLOOK.exe";
        String path = String.valueOf(pathBase) + File.separator + "Office16" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        path = String.valueOf(pathBase) + File.separator + "Office15" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        path = String.valueOf(pathBase) + File.separator + "Office14" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        path = String.valueOf(pathBase) + File.separator + "Office13" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        path = String.valueOf(pathBase) + File.separator + "Office12" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        path = String.valueOf(pathBase) + File.separator + "Office11" + File.separator + constOUTLOOKexe;
        if (new File(path).exists()) {
            return path;
        }
        return null;
    }
}

