/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.autoupdate.DownloadFile;
import org.osgi.framework.FrameworkUtil;

public class AutoupdateUtil {
    public static final String EVENT_TOPIC = "org/fao/fi/fishstat/automenu/disable";
    public static final String EVENT_PROPERTY = "event.topics";

    private AutoupdateUtil() {
    }

    public static void stopAutomenu() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEventBroker eventBroker = (IEventBroker)workbench.getService(IEventBroker.class);
        eventBroker.send(EVENT_TOPIC, (Object)EVENT_PROPERTY);
    }

    public static void openWebSite(String openURL) {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (openURL == null) {
                return;
            }
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + openURL + "\"");
            } else {
                Runtime.getRuntime().exec(new String[]{"open", "-a", "Safari", openURL});
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoUpdateMain.class.getName(), "cannot open web-site", (Throwable)e));
        }
    }

    public static VersionId getCurrentVersion() {
        String version = FrameworkUtil.getBundle(AutoUpdateMain.class).getVersion().toString();
        if (version.split("\\.").length == 4) {
            version = version.substring(0, version.lastIndexOf(46));
        }
        return new VersionId(version);
    }

    public static String getCurrentVersionXML(String currentVersionURL) {
        String xmlURL = currentVersionURL;
        VersionId version = AutoupdateUtil.getCurrentVersion();
        if (version.getFixes() >= 50 && !xmlURL.endsWith("FAO.xml")) {
            xmlURL = currentVersionURL.replace(".xml", "FAO.xml");
        }
        DownloadFile dl = new DownloadFile(xmlURL);
        return dl.GetDownloadString();
    }

    public static HttpURLConnection openConnection(String httpURL) {
        HttpURLConnection httpConnn = null;
        Proxy proxy = null;
        try {
            final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
            if (ps.getBoolean("proxy.acticated")) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, AutoUpdateMain.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.proxy"), ps.getString("proxy.server.ip"), ps.getInt("proxy.server.port"))));
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ps.getString("proxy.server.ip"), ps.getInt("proxy.server.port")));
                httpConnn = (HttpURLConnection)new URL(httpURL).openConnection(proxy);
                if (ps.getString("proxy.server.user").length() > 1) {
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(ps.getString("proxy.server.user"), ps.getString("proxy.server.password").toCharArray());
                        }
                    };
                    Authenticator.setDefault(authenticator);
                }
            } else {
                httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
            }
        }
        catch (Exception exp) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoUpdateMain.class.getName(), Activator.getPluginBundle().getString("autoupdate.error.cannotconnect"), (Throwable)exp));
            return null;
        }
        httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + AutoupdateUtil.getCurrentVersion().toString() + " " + System.getProperty("os.name"));
        return httpConnn;
    }
}

