/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.export;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.export.ObservationComparator;

public class CsvExporterNew
implements IRunnableWithProgress {
    private ExportSettings exportSettings;
    private GuiSession session;
    private Writer writer;
    private int exportedRows;
    private String measureUnit = null;
    private TimeSeriesProperties tsp;
    private MeasureDisplayer displayer = new MeasureDisplayer();
    private List<ObservationSeries> observationSeries;
    private int[] selection;
    private boolean hasAllRowsSelected;

    public CsvExporterNew(ExportSettings exportSettings, GuiSession guiSession, int[] selection, boolean hasAllRowsSelected) throws Exception {
        this.exportSettings = exportSettings;
        this.session = guiSession;
        this.tsp = this.session.getTimeseriesProperties();
        this.observationSeries = this.session.getDescriptor().getTimeseries().getObservations();
        this.selection = selection;
        this.hasAllRowsSelected = hasAllRowsSelected;
        this.setupMeasure();
    }

    public boolean selectFile() {
        String filepath;
        File file;
        block4: {
            file = null;
            try {
                FileDialog filedlg = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                filedlg.setFilterExtensions(new String[]{"*.csv"});
                filedlg.setFilterPath(String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop");
                filepath = filedlg.open();
                if (filepath != null) break block4;
                return false;
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "error writing CSV file", (Throwable)e));
                if (file != null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("csvexporter.fileerror.title"), (String)MessageFormat.format(Activator.getPluginBundle().getString("csvexporter.fileerror.message"), file.getName()));
                }
                return false;
            }
        }
        file = this.uniqueFileName(filepath);
        this.writer = new FileWriter(file);
        return true;
    }

    private File uniqueFileName(String filePath) {
        File file = new File(filePath);
        int index = 0;
        String baseName = file.getName().substring(0, file.getName().length() - 4);
        while (file.exists()) {
            file = new File(file.getParent(), String.valueOf(baseName) + "-" + ++index + ".csv");
        }
        return file;
    }

    public void run(IProgressMonitor monitor) {
        block18: {
            CsvWriter csw = null;
            try {
                try {
                    csw = new CsvWriter(this.writer, ',');
                    csw.setTextQualifier('\"');
                    int reportSize = this.selection.length + 100;
                    if (this.exportSettings.isExportTotals()) {
                        reportSize += 100;
                    }
                    monitor.beginTask(Activator.getPluginBundle().getString("csvexporter.export.start"), reportSize);
                    this.sortObservations(monitor);
                    this.exportHeaders(csw);
                    this.exportAllDenormalized(csw, monitor);
                    this.exportTotals(csw, monitor);
                    this.exportSelectionFilter(csw);
                    this.exportSelectionAggregation(csw);
                    this.exportCitation(csw);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "writing CSV data failed (out of memory?)", (Throwable)e));
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("csvexporter.exporterror.title"), (String)Activator.getPluginBundle().getString("csvexporter.exporterror.message"));
                    if (csw != null) {
                        csw.close();
                    }
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (csw != null) {
                    csw.close();
                }
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
                throw throwable;
            }
            if (csw != null) {
                csw.close();
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
        }
    }

    private void sortObservations(IProgressMonitor monitor) {
        ObservationComparator advSorter = new ObservationComparator(this.tsp);
        Collections.sort(this.observationSeries, advSorter);
        monitor.worked(100);
    }

    private void exportCitation(CsvWriter csw) throws IOException {
        if (this.exportSettings.isExportCitation() && this.session.getDataset().getCitation() != null) {
            csw.write(this.session.getDataset().getCitation().getValue(CoreCommons.LOCALE2));
            csw.endRecord();
        }
    }

    private void exportSelectionAggregation(CsvWriter csw) throws IOException {
        AggregationWrapper aggreg = this.session.getAggregationRequest();
        if (!this.exportSettings.isShowSelection()) {
            return;
        }
        if (aggreg != null) {
            DatasetProperties dsProps = this.session.getDatasetProperties();
            for (DimensionProperties dimProps : dsProps.getDimensionsProperties()) {
                StringBuilder write = new StringBuilder();
                Dimension dimension = dimProps.getDimension();
                write.append(Activator.getPluginBundle().getString("csvexporter.file.aggregation"));
                write.append(" ");
                write.append(dimension.getConcept().getAcronym());
                DimensionAggregation dimAggRequest = aggreg.getDimensionAggregation(dimProps.getDimensionIdx());
                switch (dimAggRequest.getType()) {
                    case 0: {
                        write.append(": ");
                        write.append(Activator.getPluginBundle().getString("csvexporter.file.all_details"));
                        break;
                    }
                    case 1: {
                        Concept aggregator = dimAggRequest.getBasicAggregator();
                        write.append(": ");
                        write.append(Activator.getPluginBundle().getString("csvexporter.file.by_group"));
                        write.append(" [");
                        write.append(aggregator.getName().getValue(CoreCommons.LOCALE2));
                        write.append("]");
                        break;
                    }
                    case 2: {
                        write.append(": ");
                        write.append(Activator.getPluginBundle().getString("csvexporter.file.handpicked"));
                        write.append(" [");
                        boolean firstElement = true;
                        for (Concept item : Collections.list(dimAggRequest.getIncludeParents())) {
                            if (!firstElement) {
                                write.append(",");
                            }
                            write.append(item.getName().getValue(CoreCommons.LOCALE2));
                            firstElement = false;
                        }
                        write.append("]");
                        break;
                    }
                    case 3: {
                        Concept aggregator2 = dimAggRequest.getDimension().getConcept();
                        write.append(": ");
                        write.append(Activator.getPluginBundle().getString("csvexporter.file.aggregated_by"));
                        write.append(" [");
                        write.append(aggregator2.getName().getValue(CoreCommons.LOCALE2));
                        write.append("]");
                        break;
                    }
                    default: {
                        write.append(": ");
                        write.append(Activator.getPluginBundle().getString("csvexporter.file.type"));
                        write.append("=");
                        write.append(Integer.toString(dimAggRequest.getType()));
                    }
                }
                csw.writeComment(write.toString());
            }
        } else {
            csw.writeComment("Aggregation: no aggregation defined");
        }
    }

    private void exportSelectionFilter(CsvWriter csw) throws IOException {
        FilterWrapper filter = this.session.getFilterRequest();
        if (!this.exportSettings.isShowSelection()) {
            return;
        }
        if (filter != null && filter.hasFilterSet()) {
            int i = 0;
            while (i < filter.getDimensionsSize()) {
                StringBuilder write = new StringBuilder();
                write.append("Filter ");
                write.append(filter.getDimension(i).getConcept().getAcronym());
                write.append(": ");
                ConceptSelection aSelection = filter.getConceptSelection(i);
                if (!aSelection.getExcludesList().isEmpty() && !aSelection.getIncludes().isEmpty()) {
                    Set includes = aSelection.getIncludes();
                    write.append(" include only [");
                    boolean firstElement = true;
                    for (ReferenceObject item : includes) {
                        if (!firstElement) {
                            write.append(",");
                        }
                        write.append(((MultilingualString)item.getAttribute("NAME")).getValue(CoreCommons.LOCALE2));
                        firstElement = false;
                    }
                    write.append("]");
                } else {
                    write.append(" all details (no filter defined)");
                }
                csw.writeComment(write.toString());
                ++i;
            }
        } else {
            csw.writeComment("Filter: no filter defined");
        }
    }

    private void exportTotals(CsvWriter csw, IProgressMonitor monitor) throws IOException {
        List usedMeasures = this.session.getTimeseries().getObsMeasures();
        if (!this.exportSettings.isExportTotals() || !this.hasAllRowsSelected) {
            return;
        }
        int m = 0;
        while (m < (!usedMeasures.isEmpty() ? usedMeasures.size() : 1)) {
            ReferenceObject measure = !usedMeasures.isEmpty() ? (ReferenceObject)usedMeasures.get(m) : null;
            ObservationSeries totals = this.session.getLastResult().getTotals(measure);
            String nameAtt = "";
            if (measure != null) {
                Object attVal = measure.getAttribute(measure.getConcept().getNameAttribute());
                nameAtt = attVal instanceof MultilingualString ? "- " + ((MultilingualString)attVal).getValue(Activator.getLanguage()) : "- " + attVal.toString();
            }
            int i = 0;
            while (i < this.session.getSessionMetadata().getDimColumnDescriptorsSize()) {
                csw.write(i == 0 ? "Totals " + nameAtt : "");
                ++i;
            }
            if (this.measureUnit != null) {
                csw.write("");
            }
            i = 0;
            while (i < this.tsp.getPeriodsSize()) {
                this.writeObservationMeasure(csw, this.displayer, totals.getMeasure(this.tsp.getPeriod(i)), true);
                ++i;
            }
            i = 0;
            while (i < totals.getCalculatedMeasures().size()) {
                this.writeObservationMeasure(csw, this.displayer, totals.getCalculatedMeasure(i), false);
                ++i;
            }
            csw.endRecord();
            ++m;
        }
        monitor.worked(99);
    }

    private void exportHeaders(CsvWriter csw) throws IOException {
        if (!this.exportSettings.isExportHeaders()) {
            return;
        }
        FSDimensionColumnDescriptor[] fSDimensionColumnDescriptorArray = this.session.getSessionMetadata().getAllDimColumnDescriptors();
        int n = fSDimensionColumnDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strConcept;
            FSDimensionColumnDescriptor colDesc = fSDimensionColumnDescriptorArray[n2];
            String strDimension = colDesc.getDimension() != null ? CoreUtils.getCurrentLangName((Object)colDesc.getDimension(), (String)Activator.getLanguage()) : "";
            String string = strConcept = colDesc.getConcept() != null ? CoreUtils.getCurrentLangName((Object)colDesc.getConcept(), (String)Activator.getLanguage()) : "";
            if (Activator.getDefault().getPreferenceStore().getBoolean("display.dimension.attribute")) {
                String strAttribute = colDesc.getAttribute().getName().getValue(Activator.getLanguage());
                csw.write(String.valueOf(strDimension) + " (" + strAttribute + ")");
            } else {
                csw.write(String.valueOf(strDimension) + " (" + strConcept + ")");
            }
            ++n2;
        }
        if (this.measureUnit != null) {
            csw.write("Unit");
        }
        int obsIndex = 0;
        while (obsIndex < this.tsp.getPeriods().size()) {
            csw.write("[" + this.tsp.getPeriod(obsIndex).getISO8601() + "]");
            if (this.exportSettings.isSplitSymbols() && !this.exportSettings.isNoSymbols()) {
                csw.write(this.exportSettings.getSymbolHeader());
            }
            ++obsIndex;
        }
        CalculatedMeasuresProperties cmp = this.session.getTimeseriesProperties().getCalculatedMesaureProperties();
        for (CalculatedMeasureDefinitionWrapper clcMeasure : cmp.getMeasures().values()) {
            csw.write(clcMeasure.getMeasureLabel());
            if (!this.exportSettings.isSplitSymbols() || this.exportSettings.isNoSymbols()) continue;
            csw.write(this.exportSettings.getSymbolHeader());
        }
        csw.endRecord();
    }

    private void exportAllDenormalized(CsvWriter csw, IProgressMonitor progressMonitor) throws Exception {
        Connection dbConn = this.getConn();
        int selectionIndex = 0;
        while (selectionIndex < this.selection.length) {
            ObservationSeries s = this.observationSeries.get(this.selection[selectionIndex]);
            FSDimensionColumnDescriptor[] fSDimensionColumnDescriptorArray = this.session.getSessionMetadata().getAllDimColumnDescriptors();
            int n = fSDimensionColumnDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FSDimensionColumnDescriptor colDesc = fSDimensionColumnDescriptorArray[n2];
                ReferenceObject ro = s.getKey(colDesc.getDimensionIdx());
                if (colDesc.hasRelationship()) {
                    if (colDesc.getRelationship().getChildConcept().equals(ro.getConcept())) {
                        csw.write(this.getRelationshipChildConcept(dbConn, ro, colDesc));
                    } else {
                        csw.write(this.getReferenceObject(ro, colDesc));
                    }
                } else {
                    csw.write(this.getReferenceObject(ro, colDesc));
                }
                ++n2;
            }
            if (this.measureUnit != null) {
                csw.write(this.measureUnit);
            }
            int p = 0;
            while (p < this.tsp.getPeriodsSize()) {
                this.writeObservationMeasure(csw, this.displayer, s.getMeasure(this.tsp.getPeriod(p)), true);
                ++p;
            }
            for (Measure clcMeasure : s.getCalculatedMeasures().values()) {
                this.writeObservationMeasure(csw, this.displayer, clcMeasure, false);
            }
            csw.endRecord();
            progressMonitor.worked(1);
            ++this.exportedRows;
            ++selectionIndex;
        }
    }

    private String getRelationshipChildConcept(Connection dbConn, ReferenceObject ro, FSDimensionColumnDescriptor colDesc) {
        ResultSet rs2;
        PreparedStatement p2;
        String atttib;
        block6: {
            ResultSet rs1;
            PreparedStatement p1;
            block5: {
                String relTable = "REL_" + colDesc.getRelationship().getAcronym();
                String roID = ro.getId().toString();
                atttib = colDesc.getAttribute().getAcronym();
                if (colDesc.getAttribute().getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                    atttib = String.valueOf(atttib) + "_" + Activator.getLanguage().toUpperCase();
                }
                try {
                    String sqlQuery1 = "SELECT * from FISHSTAT." + relTable + " WHERE CHILD_ID=?";
                    p1 = dbConn.prepareStatement(sqlQuery1);
                    p1.setString(1, roID);
                    rs1 = p1.executeQuery();
                    if (rs1.next()) break block5;
                    rs1.close();
                    p1.close();
                    return "";
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "queryRelation", (Throwable)e));
                    return "";
                }
            }
            String parentID = rs1.getString("PARENT_ID");
            rs1.close();
            p1.close();
            String refTable = "REF_" + colDesc.getConcept().getAcronym();
            String sqlQuery2 = "SELECT * from FISHSTAT." + refTable + " WHERE ID=?";
            p2 = dbConn.prepareStatement(sqlQuery2);
            p2.setString(1, parentID);
            rs2 = p2.executeQuery();
            if (rs2.next()) break block6;
            rs2.close();
            p2.close();
            return "";
        }
        String value = rs2.getString(atttib);
        rs2.close();
        p2.close();
        return value;
    }

    private Connection getConn() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        WorkspaceModel workspaceModel = CoreCommons.getWorkspacesManager().getCurrentWorkspace();
        return DriverManager.getConnection(workspaceModel.getDbUrl(), workspaceModel.getDbUsername(), workspaceModel.getDbPassword());
    }

    private String getReferenceObject(ReferenceObject ro, FSDimensionColumnDescriptor descriptor) {
        if (ro == null || ro.equals(ReferenceObject.NULL)) {
            return "";
        }
        if (ro.equals(ReferenceObject.ALL) || ro.equals(ReferenceObject.OTHERS) || ro.equals(ReferenceObject.UNKNOWN)) {
            return CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (String)"NAME", (String)Activator.getLanguage());
        }
        if (ro.getConcept().equals(descriptor.getConcept())) {
            return CoreUtils.getTextualValueLabel((ReferenceObject)ro, (FSDimensionColumnDescriptor)descriptor, (String)Activator.getLanguage());
        }
        return CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)ro.getConcept().getNameAttribute(), (String)Activator.getLanguage());
    }

    private void writeObservationMeasure(CsvWriter csw, MeasureDisplayer displayer, Measure cms, boolean valueObserved) throws IOException {
        if (this.exportSettings.isNoSymbols()) {
            if (cms == null) {
                csw.write("");
            } else {
                csw.write(displayer.getOnlyValue(cms, true));
            }
        } else if (this.exportSettings.isSplitSymbols()) {
            if (cms == null) {
                csw.write("");
                csw.write("");
            } else {
                csw.write(displayer.getOnlyValue(cms, valueObserved));
                csw.write(displayer.getStatusLabel(cms));
            }
        } else if (cms == null) {
            csw.write("");
        } else {
            csw.write(displayer.getMeasureLabel(cms, true));
        }
    }

    private void setupMeasure() {
        if (this.session.getUnitValue() != null && this.session.getUnitValue().length == 2 && this.session.getUnitValue()[0] != null) {
            this.measureUnit = this.getMeasureDisplay(this.session.getUnitValue());
        }
    }

    private String getMeasureDisplay(String[] unit) {
        String[] unitCodes;
        String measureCode = unit[0];
        Concept concept = ReferenceServiceFactory.getService().getConcept("MEASURE");
        StringBuilder unitText = new StringBuilder();
        String[] stringArray = unitCodes = measureCode.split(",");
        int n = unitCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String oneCode = stringArray[n2];
            ReferenceObject refObject = concept.getObject(concept.getAttribute("CODE"), (Object)this.mapLegacyUnits(oneCode, unit[1]));
            if (refObject == null) {
                return "";
            }
            if (unitText.length() > 0) {
                unitText.append(", ");
            }
            Object shortNameAtt = refObject.getAttribute("SHORT_NAME");
            Object nameAtt = refObject.getAttribute("NAME");
            if (shortNameAtt != null) {
                unitText.append(shortNameAtt.toString());
            } else {
                unitText.append(((MultilingualString)nameAtt).getValue(CoreCommons.LOCALE2));
            }
            ++n2;
        }
        return unitText.toString();
    }

    private String mapLegacyUnits(String unit, String multiplier) {
        if (unit.equals("USD") && multiplier != null && multiplier.equals("3")) {
            return "V_USD_1000";
        }
        if (unit.equals("no") && multiplier != null && multiplier.equals("3")) {
            return "Q_no_1000";
        }
        if (unit.equals("t") && multiplier != null && multiplier.equals("0")) {
            return "Q_t_1";
        }
        if (unit.equals("no")) {
            return "Q_no_1";
        }
        if (unit.equals("tlw")) {
            return "Q_tlw";
        }
        if (unit.equals("tpw")) {
            return "Q_tpw";
        }
        return unit;
    }

    public int getExportedRows() {
        return this.exportedRows;
    }
}

