/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.export;

import java.util.Comparator;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.views.multitable.AttributeCache;

class ObservationComparator
implements Comparator<ObservationSeries> {
    private MultiSortProperties sortProperties;
    private AttributeCache[] cache = null;

    public ObservationComparator(TimeSeriesProperties p) {
        this.sortProperties = p.getSorter();
        this.cache = new AttributeCache[this.sortProperties.size()];
        int i = 0;
        while (i < this.cache.length) {
            if (this.sortProperties.getSorter(i).getType() == 'D') {
                this.cache[i] = new AttributeCache(this.sortProperties.getSorter(i));
            }
            ++i;
        }
    }

    @Override
    public int compare(ObservationSeries e1, ObservationSeries e2) {
        int i = 0;
        while (i < this.sortProperties.size()) {
            MultiSortElemProperties sorter = this.sortProperties.getSorter(i);
            if (sorter.isActive()) {
                if (sorter.getType() == 'D') {
                    ReferenceObject key2;
                    ReferenceObject key1 = e1.getKey(sorter.getDimensionIdx());
                    if (!key1.equals(key2 = e2.getKey(sorter.getDimensionIdx()))) {
                        String r2;
                        if (CoreCache.isPredefined((ReferenceObject)key1)) {
                            return 1;
                        }
                        if (CoreCache.isPredefined((ReferenceObject)key2)) {
                            return -1;
                        }
                        String r1 = this.cache[i].getString(key1);
                        if (!r1.equals(r2 = this.cache[i].getString(key2))) {
                            return sorter.isAscending() ? r1.compareTo(r2) : r2.compareTo(r1);
                        }
                    }
                } else {
                    Measure m2;
                    Measure m1 = e1.getMeasure(sorter.getObservationPeriod());
                    if (!m1.equals(m2 = e2.getMeasure(sorter.getObservationPeriod()))) {
                        return (sorter.isAscending() ? 1 : -1) * m1.compareTo((Object)m2);
                    }
                }
            }
            ++i;
        }
        return 0;
    }
}

