/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.io.File;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.combos.DatasetAttachmentsComboViewer;
import org.fao.fi.fishstat.gui.views.PDFviewerComposite;

public class DatasetAttachmentsComposite
extends Composite {
    private Browser browser;
    private Composite pdfComposite;
    private DatasetAttachmentsComboViewer datasetAttachmentsComboViewer;
    private String noAttachmentsAvailable = "<html><body><p><span lang=EN-GB style='font-size:9.0pt;font-family:\"Arial\",\"sans-serif\";color:#17365D'>" + Activator.getLocalString("message.no.attachments.available") + "</span></p></body></html>";

    public DatasetAttachmentsComposite(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        this.setLayout((Layout)gridLayout);
        Label lblNewLabel = new Label((Composite)this, 0);
        GridData gdLblNewLabel = new GridData(16384, 128, false, false, 1, 1);
        gdLblNewLabel.widthHint = 105;
        lblNewLabel.setLayoutData((Object)gdLblNewLabel);
        lblNewLabel.setText(Activator.getLocalString("label.attachments"));
        this.datasetAttachmentsComboViewer = new DatasetAttachmentsComboViewer((Composite)this, 0, Activator.getLanguage());
        this.datasetAttachmentsComboViewer.addSelectionChangedListener(event -> this.attachmentSelectionChanged());
        this.datasetAttachmentsComboViewer.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        this.browser = new Browser((Composite)this, 2048);
        this.browser.setJavascriptEnabled(false);
        this.browser.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.browser.setVisible(false);
        this.pdfComposite = new PDFviewerComposite(this, 0);
        GridData gdViewer = new GridData(4, 4, false, true, 2, 1);
        gdViewer.exclude = true;
        this.pdfComposite.setLayoutData((Object)gdViewer);
        this.pdfComposite.setVisible(false);
    }

    private void doRequestLayout() {
        this.layout(true);
    }

    private void attachmentSelectionChanged() {
        Attachment selection = this.datasetAttachmentsComboViewer.getSelectedAttachment();
        if (selection != null && selection.getFileName() != null) {
            String url = String.valueOf(CoreRegistry.getAttachmentsPath().getAbsolutePath()) + File.separator + selection.getFileName().getValue(Activator.getLanguage());
            if (url.toLowerCase().endsWith(".pdf")) {
                GridData hidden = (GridData)this.browser.getLayoutData();
                hidden.exclude = true;
                this.browser.setVisible(false);
                GridData visible = (GridData)this.pdfComposite.getLayoutData();
                visible.exclude = false;
                this.pdfComposite.setVisible(true);
                ((PDFviewerComposite)this.pdfComposite).openPDFdocument(url);
            } else {
                GridData hidden = (GridData)this.pdfComposite.getLayoutData();
                hidden.exclude = true;
                this.pdfComposite.setVisible(false);
                GridData visible = (GridData)this.browser.getLayoutData();
                visible.exclude = false;
                this.browser.setVisible(true);
                this.browser.setUrl(url);
            }
            this.doRequestLayout();
        }
    }

    public final void setInput(Object input) {
        this.datasetAttachmentsComboViewer.setInput(input);
        if (this.datasetAttachmentsComboViewer.getItemCount() == 0) {
            this.browser.setText(this.noAttachmentsAvailable);
        } else {
            Attachment firstAttachment = (Attachment)this.datasetAttachmentsComboViewer.getComboViewer().getElementAt(0);
            this.datasetAttachmentsComboViewer.setSelection(firstAttachment);
        }
    }
}

